// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 02/07/1997 
// Date Last Modified: 10/15/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is test program for the Disk-based binary search tree.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include "dtree.hpp"
#include "cacstats.hpp"

void ListInOrder(CachePointer Tree) // For test purposes only
{
  CachePointer l(Tree); // Using Tree to get cache
  while((__LWORD__)Tree) {
    l = Tree->Left;
    Tree.Release(); // Otherwise cache might fill up
    ListInOrder(l);
    cout << "FAU: " << (__LWORD__)Tree << ' ' << "Data: "
	 << Tree->Data << endl;
    Tree = Tree->Right;
  }
}

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  // (D)isk-based binary search (T)ree (I)ndex file extension
  char *FName = "testfile.dtx";
  
  cout << "Creating a disk-based tree..." << endl;
  DTree dtree(5);
  VBDFilePtr fp(new VBDFile); // Must ALWAYS create dynamically
  // Create the file with room for one tree header in the static area
  fp->Create(FName, sizeof(TreeHeader));
  dtree.Connect(fp, 1, sizeof(FileHeader));

  int ex;

  FKey a("DOG");
  FKey b("CAT");
  FKey c("COW");
  FKey d("MOUSE");
  FKey e("BIRD");
  FKey f("PIG");
  FKey g("HORSE");
  FKey h("LION");
  FKey i("SNAKE");
  FKey j("FISH");

  FKey k("THE QUICK BROWN FOX");

  CachePointer a1 = dtree.Add(a, ex);
  cout << "Adding " << a << " to database at FAU " << __LWORD__(a1) << endl;

  CachePointer a2 = dtree.Add(b, ex);
  cout << "Adding " << b << " to database at FAU " << __LWORD__(a2) << endl;
  
  CachePointer a3 = dtree.Add(c, ex);
  cout << "Adding " << c << " to database at FAU " << __LWORD__(a3) << endl;
  
  CachePointer a4 = dtree.Add(d, ex);
  cout << "Adding " << d << " to database at FAU " << __LWORD__(a4) << endl;

  CachePointer a5 = dtree.Add(e, ex);
  cout << "Adding " << e << " to database at FAU " << __LWORD__(a5) << endl;
  
  CachePointer a6 = dtree.Add(f, ex);
  cout << "Adding " << f << " to database at FAU " << __LWORD__(a6) << endl;
  
  CachePointer a7 = dtree.Add(g, ex);
  cout << "Adding " << g << " to database at FAU " << __LWORD__(a7) << endl;

  CachePointer a8 = dtree.Add(h, ex);
  cout << "Adding " << h << " to database at FAU " << __LWORD__(a8) << endl;

  CachePointer a9 = dtree.Add(i, ex);
  cout << "Adding " << i << " to database at FAU " << __LWORD__(a9) << endl;
  
  CachePointer a10 = dtree.Add(j, ex);
  cout << "Adding " << j << " to database at FAU " << __LWORD__(a10) << endl;
  
  pause();
  
  cout << "Tree data: " << endl;
  ListInOrder(dtree.Root); 

  cout << endl;
  cout << "Cache report: " << endl;
  Report(dtree.cache, 0);
  
  pause();

  cout << "Changing persistent FKey object " << j << " to " << k << endl;
  dtree.Change(j, k);

  cout << endl;
  cout << "Tree data: " << endl;
  ListInOrder(dtree.Root); 
  
  pause();

  cout << "Deleting item " << a << " from the database..." << endl;
  dtree.Delete(a);

  cout << "Deleting item " << e << " from the database..." << endl;
  dtree.Delete(e);

  cout << "Deleting item " << k << " from the database..." << endl;
  dtree.Delete(k);
  
  cout << endl;
  cout << "Tree data: " << endl;
  ListInOrder(dtree.Root); 

  pause();
  
  cout << "Closing and re-opening the file..." << endl;
  dtree.Disconnect(); // Avoid a dangling cache pointer exception
  fp->Open(FName, VBDFile::READONLY); // Open() closes first
  dtree.Connect(fp, 0, sizeof(FileHeader)); // 0 means open

  pause();

  cout << "Tree data: " << endl;
  ListInOrder(dtree.Root); 

  pause();

  cout << "Searching database for item " << c << endl;
  CachePointer cp = dtree.Search(c);
  if((__LWORD__)cp) cout << "Found item " << c << " at FAU "
			 << __LWORD__(cp) << endl;

  pause();
  
  cout << "Creating two disk-based trees connected to the same file..."
       << endl;

  DTree dtree1(5);
  DTree dtree2(5);
  VBDFilePtr myfile(new VBDFile); // Must ALWAYS create dynamically

  // Create the file with room for two tree headers
  // in the static area
  myfile->Create(FName, 2*sizeof(TreeHeader));

  // Connect the first tree, create the tree, with a header
  // at the location right after the VBDFileHeader.
  dtree1.Connect(myfile, 1, sizeof(FileHeader));

  // Connect the second tree, create the tree, with a header
  // at the location right after the first tree's header.
  dtree2.Connect(myfile, 1, sizeof(FileHeader)+sizeof(TreeHeader));

  cout << "Adding to both trees at same time..." << endl;
  dtree1.Add(a, ex);
  dtree2.Add(b, ex);
  dtree1.Add(c, ex);
  dtree2.Add(d, ex);
  dtree1.Add(e, ex);
  dtree2.Add(f, ex); 
  dtree1.Add(g, ex);
  dtree2.Add(h, ex);
  dtree1.Add(i, ex);
  dtree2.Add(j, ex);

  cout << endl;
  cout << "Tree #1's cache:" << endl;
  Report(dtree1.cache, 0);

  cout << endl;
  cout << "Tree #2's cache:" << endl;
  Report(dtree2.cache, 0);

  pause();

  cout << "Closing and re-opening the file..." << endl;

  dtree1.Disconnect(); // Avoid a dangling cache pointer exception
  dtree2.Disconnect(); // Avoid a dangling cache pointer exception

  myfile->Open(FName, VBDFile::READONLY); // Open() closes first

  dtree1.Connect(myfile, 0, sizeof(FileHeader)); // 0 means open
  dtree2.Connect(myfile, 0, sizeof(FileHeader)+sizeof(TreeHeader));

  pause();
  
  cout << "Tree #1's data:" << endl;
  ListInOrder(dtree1.Root); 

  cout << endl;
  cout << "Tree #2's data:" << endl;
  ListInOrder(dtree2.Root); 

  pause();
  
  cout << "Tree #1's cache:" << endl;
  Report(dtree1.cache, 0);

  cout << endl;
  cout << "Tree #2's cache:" << endl;
  Report(dtree2.cache, 0);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


