// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dtypes.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This file contains typedefs and constants used to maintain
compatiblity between the built-in data type sizes on various
compilers.

Changes: 
================================================================
12/16/1997 - Added leading and trailing double underscores to
type names to avoid any name conflicts with other libraries.
Changed by: Doug Gaer

12/16/1997 - Added __USE_OLD_TYPE_NAMES__ macro to conditionally
compile with old type names.
Changed by: Doug Gaer

05/28/1998 - Added __USE_DTYPES_CONSTANTS__ macro to enable or
disable the positive and negitive limits constants defined in
this file.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __DTYPES_HPP__
#define __DTYPES_HPP__

// NOTE: These typedefs were renamed to avoid name conficts 
typedef char __SBYTE__;            // 8-bit signed value
typedef unsigned char __UBYTE__;   // 8-bit unsigned value
typedef int __WORD__;              // (W)ord size (4 bytes) 
typedef unsigned __UWORD__;        // (U)nsigned (W)ord size (4 bytes)
typedef long __LWORD__;            // (L)ong (W)ord size (4 bytes)
typedef unsigned long __ULWORD__;  // (U)nsigned (L)ong (W)ord size (4 Bytes)
typedef short __SWORD__;           // (S)hort (W)ord size (2 bytes)
typedef unsigned short __USWORD__; // (U)nsigned (S)hort (W)ord size (2 bytes) 
typedef double __DPFLOAT__; // (D)ouble (P)recision (F)loating point (8 bytes)

// Define this macro to compile with these previous type names.
// #ifndef __USE_OLD_TYPE_NAMES__
// #define __USE_OLD_TYPE_NAMES__
// #endif

// These typedefs provide compatibility with the previous releases.
#ifdef __USE_OLD_TYPE_NAMES__
typedef char SBYTE;            // 8-bit signed value
typedef unsigned char UBYTE;   // 8-bit unsigned value
typedef int WORD;              // (W)ord size (4 bytes) 
typedef unsigned UWORD;        // (U)nsigned (W)ord size (4 bytes)
typedef long LWORD;            // (L)ong (W)ord size (4 bytes)
typedef unsigned long ULWORD;  // (U)nsigned (L)ong (W)ord size (4 Bytes)
typedef short SWORD;           // (S)hort (W)ord size (2 bytes)
typedef unsigned short USWORD; // (U)nsigned (S)hort (W)ord size (2 bytes) 
typedef double DPFLOAT; // (D)ouble (P)recision (F)loating point (8 bytes)
#endif

// Define this macro to use the positive and negitive limits
// constants defined in this file.
// #ifndef __USE_DTYPES_CONSTANTS__
// #define __USE_DTYPES_CONSTANTS__
// #endif

#ifdef __USE_DTYPES_CONSTANTS__
// Positive and Negitive limits Constants 
const __LWORD__   LWORDPositiveLimit = 2147483647;
const __LWORD__   LWORDNegitiveLimit = 2147483648;
const __ULWORD__  ULWORDLimit        = 4294967295;
const __WORD__    WORDPositiveLimit  = 2147483647;
const __WORD__    WORDNegitiveLimit  = 2147483648;
const __UWORD__   UWORDLimit         = 4294967295;
const __SWORD__   SWORDPositiveLimit = 32767;
const __SWORD__   SWORDNegitiveLimit = 32768;
const __USWORD__  USWORDLimit        = 65535;
const __DPFLOAT__ DPFLOATPositiveLimit = 1.7E+308; // (15 digit precision)
const __DPFLOAT__ DPFLOATNegitiveLimit = 1.7E-308; // (15 digit precision)
#endif // __USE_DTYPES_CONSTANTS__

#endif // __DTYPES_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
