// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: int16.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The INT16 class is used to represent 16 bit signed integers
independently of the operating system or hardware platform used.
It works by separating 16-bit values into two separate byte
values and reordering the bytes lowest-order to highest-order.
An INT16 type has a base 10 positive limit of 32,767 and a
negative limit of 32,768.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <memory.h>
#include "int16.hpp"
#include "ehandler.hpp"

INT16::INT16(__SWORD__ val)
{
  UnPackBits(val);
}

INT16::INT16(const INT16& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 2);
}

INT16& INT16::operator=(const INT16& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 2);
  return *this;
}

INT16& INT16::operator=(const __SWORD__ val)
{
  UnPackBits(val);
  return *this;
}

INT16::operator __SWORD__() const
{
  return PackBits();
}

__SWORD__ INT16::PackBits() const
{
  __SWORD__ a, b;
  
  a = (__SWORD__)byte[0];
  b = (__SWORD__)byte[1];

  a = a & 0xFF;
  b = (b<<8) & 0xFF00;

  return a + b;
}

void INT16::UnPackBits(__SWORD__ val)
{
  byte[0] = val & 0xFF;
  byte[1] = (val & 0xFF00)>>8;
}

INT16 INT16::operator++(int) // Postfix
{
  INT16 val_before(*this); 
  operator=(*this + 1);
  return val_before;
}
 
INT16 INT16::operator--(int) // Postfix
{
  INT16 val_before(*this); 
  operator=(*this - 1);
  return val_before;
}

void INT16::operator/=(const INT16 &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __LWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

    operator=(*this / i);
}

void INT16::operator/=(const __ULWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __WORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __SWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __UWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __USWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void INT16::operator/=(const __SBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__SWORD__)i);
}

void INT16::operator/=(const __UBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__SWORD__)i);
}

int operator==(const INT16 &a, const INT16 &b)
{
  return a.PackBits() == b.PackBits();
}

int operator==(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __LWORD__ &as, const INT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __ULWORD__ &as, const INT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __WORD__ &as, const INT16 &b)
{
  return as == b.PackBits();
}

int operator==(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __SWORD__ &as, const INT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __UWORD__ &as, const INT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const INT16 &a, const __USWORD__ &bs)
{
  return  a.PackBits() == bs;
}

int operator==(const __USWORD__ &as, const INT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs;
}

int operator==(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits(); 
}

int operator==(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs;
}

int operator==(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits(); 
}

int operator!=(const INT16 &a, const INT16 &b)
{
  return a.PackBits() != b.PackBits();
}

int operator!=(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __LWORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __ULWORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __WORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __SWORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __UWORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __USWORD__ &as, const INT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() != (__SWORD__)bs;
}

int operator!=(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as != b.PackBits();
}

int operator!=(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() != (__SWORD__)bs;
}

int operator!=(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as != b.PackBits();
}

int operator<(const INT16 &a, const INT16 &b)
{
  return a.PackBits() < b.PackBits();
}

int operator<(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __LWORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __ULWORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __WORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __SWORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __UWORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __USWORD__ &as, const INT16 &b)
{
  return as < b.PackBits();
}

int operator<(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() < (__SWORD__)bs;
}

int operator<(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as < b.PackBits();
}

int operator<(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() < (__SWORD__)bs;
}

int operator<(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as < b.PackBits();
}

int operator>(const INT16 &a, const INT16 &b)
{
  return a.PackBits() > b.PackBits();
}

int operator>(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __LWORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __ULWORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __WORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __SWORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __UWORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __USWORD__ &as, const INT16 &b)
{
  return as > b.PackBits();
}

int operator>(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() > (__SWORD__)bs;
}

int operator>(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as > b.PackBits();
}

int operator>(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() > (__SWORD__)bs;
}

int operator>(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as > b.PackBits();
}

int operator<=(const INT16 &a, const INT16 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() < b.PackBits();
}

int operator<=(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __LWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __ULWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __WORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __SWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __UWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __USWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs ||  a.PackBits() < (__SWORD__)bs;
}

int operator<=(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits() || (__SWORD__)as < b.PackBits();
}

int operator<=(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs ||  a.PackBits() < (__SWORD__)bs;
}

int operator<=(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits() || (__SWORD__)as < b.PackBits();
}

int operator>=(const INT16 &a, const INT16 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() > b.PackBits();
}

int operator>=(const INT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __LWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __ULWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __WORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __SWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __UWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __USWORD__ &as, const INT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const INT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs || a.PackBits() > (__SWORD__)bs;
}

int operator>=(const __SBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits() || (__SWORD__)as > b.PackBits();
}

int operator>=(const INT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__SWORD__)bs || a.PackBits() > (__SWORD__)bs;
}

int operator>=(const __UBYTE__ &as, const INT16 &b)
{
  return (__SWORD__)as == b.PackBits() || (__SWORD__)as > b.PackBits();
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
