// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: int16.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The INT16 class is used to represent 16 bit signed integers
independently of the operating system or hardware platform used.
It works by separating 16-bit values into two separate byte
values and reordering the bytes lowest-order to highest-order.
An INT16 type has a base 10 positive limit of 32,767 and a
negative limit of 32,768.
*/
// ----------------------------------------------------------- //   
#ifndef __INT16_HPP
#define __INT16_HPP

#include "dtypes.hpp"

// Data structure for signed 16 bit integer values.
class INT16
{
public:
  INT16(__SWORD__ val = 0);
  INT16(const INT16& ob);
  INT16& operator=(const INT16& ob);
  INT16& operator=(const __SWORD__ ob);

public:
  void UnPackBits(__SWORD__ val);
  __SWORD__ PackBits() const;

public:
  operator __SWORD__() const;
  
public: // Arithmetic operators that modify their operand
  INT16 operator++(int);  // Postfix
  INT16 operator--(int);  // Postfix
  INT16 &operator++() { operator=(*this + 1); return *this; } // Prefix
  INT16 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const INT16 &i) { operator=(*this + i); }
  void operator-=(const INT16 &i) { operator=(*this - i); }
  void operator*=(const INT16 &i) { operator=(*this * i); }
  void operator/=(const INT16 &i);

  void operator+=(const __LWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + i); }
  void operator-=(const __WORD__ &i) { operator=(*this - i); }
  void operator*=(const __WORD__ &i) { operator=(*this * i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__SWORD__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__SWORD__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__SWORD__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__SWORD__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__SWORD__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__SWORD__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const INT16 &a, const INT16 &b);
  friend int operator==(const INT16 &a, const __LWORD__ &bs);
  friend int operator==(const __LWORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __ULWORD__ &bs);
  friend int operator==(const __ULWORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __WORD__ &bs);
  friend int operator==(const __WORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __SWORD__ &bs);
  friend int operator==(const __SWORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __UWORD__ &bs);
  friend int operator==(const __UWORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __USWORD__ &bs);
  friend int operator==(const __USWORD__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __SBYTE__ &bs);
  friend int operator==(const __SBYTE__ &as, const INT16 &b);
  friend int operator==(const INT16 &a, const __UBYTE__ &bs);
  friend int operator==(const __UBYTE__ &as, const INT16 &b);

  friend int operator!=(const INT16 &a, const INT16 &b);
  friend int operator!=(const INT16 &a, const __LWORD__ &bs);
  friend int operator!=(const __LWORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __ULWORD__ &bs);
  friend int operator!=(const __ULWORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __WORD__ &bs);
  friend int operator!=(const __WORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __SWORD__ &bs);
  friend int operator!=(const __SWORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __UWORD__ &bs);
  friend int operator!=(const __UWORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __USWORD__ &bs);
  friend int operator!=(const __USWORD__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __SBYTE__ &bs);
  friend int operator!=(const __SBYTE__ &as, const INT16 &b);
  friend int operator!=(const INT16 &a, const __UBYTE__ &bs);
  friend int operator!=(const __UBYTE__ &as, const INT16 &b);

  friend int operator<(const INT16 &a, const INT16 &b);
  friend int operator<(const INT16 &a, const __LWORD__ &bs);
  friend int operator<(const __LWORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __ULWORD__ &bs);
  friend int operator<(const __ULWORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __WORD__ &bs);
  friend int operator<(const __WORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __SWORD__ &bs);
  friend int operator<(const __SWORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __UWORD__ &bs);
  friend int operator<(const __UWORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __USWORD__ &bs);
  friend int operator<(const __USWORD__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __SBYTE__ &bs);
  friend int operator<(const __SBYTE__ &as, const INT16 &b);
  friend int operator<(const INT16 &a, const __UBYTE__ &bs);
  friend int operator<(const __UBYTE__ &as, const INT16 &b);

  friend int operator>(const INT16 &a, const INT16 &b);
  friend int operator>(const INT16 &a, const __LWORD__ &bs);
  friend int operator>(const __LWORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __ULWORD__ &bs);
  friend int operator>(const __ULWORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __WORD__ &bs);
  friend int operator>(const __WORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __SWORD__ &bs);
  friend int operator>(const __SWORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __UWORD__ &bs);
  friend int operator>(const __UWORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __USWORD__ &bs);
  friend int operator>(const __USWORD__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __SBYTE__ &bs);
  friend int operator>(const __SBYTE__ &as, const INT16 &b);
  friend int operator>(const INT16 &a, const __UBYTE__ &bs);
  friend int operator>(const __UBYTE__ &as, const INT16 &b);

  friend int operator<=(const INT16 &a, const INT16 &b);
  friend int operator<=(const INT16 &a, const __LWORD__ &bs);
  friend int operator<=(const __LWORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __ULWORD__ &bs);
  friend int operator<=(const __ULWORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __WORD__ &bs);
  friend int operator<=(const __WORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __SWORD__ &bs);
  friend int operator<=(const __SWORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __UWORD__ &bs);
  friend int operator<=(const __UWORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __USWORD__ &bs);
  friend int operator<=(const __USWORD__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __SBYTE__ &bs);
  friend int operator<=(const __SBYTE__ &as, const INT16 &b);
  friend int operator<=(const INT16 &a, const __UBYTE__ &bs);
  friend int operator<=(const __UBYTE__ &as, const INT16 &b);

  friend int operator>=(const INT16 &a, const INT16 &b);
  friend int operator>=(const INT16 &a, const __LWORD__ &bs);
  friend int operator>=(const __LWORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __ULWORD__ &bs);
  friend int operator>=(const __ULWORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __WORD__ &bs);
  friend int operator>=(const __WORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __SWORD__ &bs);
  friend int operator>=(const __SWORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __UWORD__ &bs);
  friend int operator>=(const __UWORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __USWORD__ &bs);
  friend int operator>=(const __USWORD__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __SBYTE__ &bs);
  friend int operator>=(const __SBYTE__ &as, const INT16 &b);
  friend int operator>=(const INT16 &a, const __UBYTE__ &bs);
  friend int operator>=(const __UBYTE__ &as, const INT16 &b);
  
private:
  __SBYTE__ byte[2];
};

#endif // __INT16_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
