// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: uint16.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The UINT16 class is used to represent 16 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 16-bit value into two separate byte
values and reordering the bytes lowest-order to highest-order.
An UINT16 type has a base 10 positive limit of 65,535.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <memory.h>
#include "uint16.hpp"
#include "ehandler.hpp"

UINT16::UINT16(__USWORD__ val)
{
  UnPackBits(val);
}

UINT16::UINT16(const UINT16& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 2);
}

UINT16& UINT16::operator=(const UINT16& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 2);
  return *this;
}

UINT16& UINT16::operator=(const __USWORD__ val)
{
  UnPackBits(val);
  return *this;
}

UINT16::operator __USWORD__() const
{
  return PackBits();
}

__USWORD__ UINT16::PackBits() const
{
  __USWORD__ a, b;
  
  a = (__USWORD__)byte[0];
  b = (__USWORD__)byte[1];

  a = a & 0xFF;
  b = (b<<8) & 0xFF00;

  return a + b;
}

void UINT16::UnPackBits(__USWORD__ val)
{
  byte[0] = val & 0xFF;
  byte[1] = (val & 0xFF00)>>8;
}

UINT16 UINT16::operator++(int) // Postfix
{
  UINT16 val_before(*this); 
  operator=(*this + 1);
  return val_before;
}
 
UINT16 UINT16::operator--(int) // Postfix
{
  UINT16 val_before(*this); 
  operator=(*this - 1);
  return val_before;
}

void UINT16::operator/=(const UINT16 &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __LWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

    operator=(*this / i);
}

void UINT16::operator/=(const __ULWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __WORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __SWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __UWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __USWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT16::operator/=(const __SBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__USWORD__)i);
}

void UINT16::operator/=(const __UBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__USWORD__)i);
}

int operator==(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() == b.PackBits();
}

int operator==(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __LWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __ULWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __WORD__ &as, const UINT16 &b)
{
  return as == b.PackBits();
}

int operator==(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __SWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs;
}

int operator==(const __UWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __USWORD__ &bs)
{
  return  a.PackBits() == bs;
}

int operator==(const __USWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs;
}

int operator==(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits(); 
}

int operator==(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs;
}

int operator==(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits(); 
}

int operator!=(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() != b.PackBits();
}

int operator!=(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __LWORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __ULWORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __WORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __SWORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __UWORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() != bs;
}

int operator!=(const __USWORD__ &as, const UINT16 &b)
{
  return as != b.PackBits();
}

int operator!=(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() != (__USWORD__)bs;
}

int operator!=(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as != b.PackBits();
}

int operator!=(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() != (__USWORD__)bs;
}

int operator!=(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as != b.PackBits();
}

int operator<(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() < b.PackBits();
}

int operator<(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __LWORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __ULWORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __WORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __SWORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __UWORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() < bs;
}

int operator<(const __USWORD__ &as, const UINT16 &b)
{
  return as < b.PackBits();
}

int operator<(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() < (__USWORD__)bs;
}

int operator<(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as < b.PackBits();
}

int operator<(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() < (__USWORD__)bs;
}

int operator<(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as < b.PackBits();
}

int operator>(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() > b.PackBits();
}

int operator>(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __LWORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __ULWORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __WORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __SWORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __UWORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() > bs;
}

int operator>(const __USWORD__ &as, const UINT16 &b)
{
  return as > b.PackBits();
}

int operator>(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() > (__USWORD__)bs;
}

int operator>(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as > b.PackBits();
}

int operator>(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() > (__USWORD__)bs;
}

int operator>(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as > b.PackBits();
}

int operator<=(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() < b.PackBits();
}

int operator<=(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __LWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __ULWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __WORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __SWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __UWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() < bs;
}

int operator<=(const __USWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as < b.PackBits();
}

int operator<=(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs ||  a.PackBits() < (__USWORD__)bs;
}

int operator<=(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits() || (__USWORD__)as < b.PackBits();
}

int operator<=(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs ||  a.PackBits() < (__USWORD__)bs;
}

int operator<=(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits() || (__USWORD__)as < b.PackBits();
}

int operator>=(const UINT16 &a, const UINT16 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() > b.PackBits();
}

int operator>=(const UINT16 &a, const __LWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __LWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __ULWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __ULWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __WORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __WORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __SWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __SWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __UWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __UWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __USWORD__ &bs)
{
  return a.PackBits() == bs || a.PackBits() > bs;
}

int operator>=(const __USWORD__ &as, const UINT16 &b)
{
  return as == b.PackBits() || as > b.PackBits();
}

int operator>=(const UINT16 &a, const __SBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs || a.PackBits() > (__USWORD__)bs;
}

int operator>=(const __SBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits() || (__USWORD__)as > b.PackBits();
}

int operator>=(const UINT16 &a, const __UBYTE__ &bs)
{
  return a.PackBits() == (__USWORD__)bs || a.PackBits() > (__USWORD__)bs;
}

int operator>=(const __UBYTE__ &as, const UINT16 &b)
{
  return (__USWORD__)as == b.PackBits() || (__USWORD__)as > b.PackBits();
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
