// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: uint32.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The UINT32 class is used to represent 32 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 32-bit value into four separate byte
values and reordering the bytes lowest-order to highest-order.
An UINT32 type has a base 10 limit of 4,294,967,295.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <memory.h>
#include "uint32.hpp"
#include "ehandler.hpp"

UINT32::UINT32(__ULWORD__ val)
{
  UnPackBits(val);
}

UINT32::UINT32(const UINT32& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 4);
}

UINT32& UINT32::operator=(const UINT32& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 4);
  return *this;
}

UINT32& UINT32::operator=(const __ULWORD__ val)
{
  UnPackBits(val);
  return *this;
}

UINT32::operator __ULWORD__() const
{
  return PackBits();
}

__ULWORD__ UINT32::PackBits() const
{
  __ULWORD__ a, b, c, d;
  
  a = (__ULWORD__)byte[0];
  b = (__ULWORD__)byte[1];
  c = (__ULWORD__)byte[2];
  d = (__ULWORD__)byte[3];

  a = a & 0xFF;
  b = (b<<8) & 0xFF00;
  c = (c<<16) & 0xFF0000;
  d = (d<<24) & 0xFF000000;

  return a + b + c + d;
}

void UINT32::UnPackBits(__ULWORD__ val)
{
  byte[0] = val & 0xFF;
  byte[1] = (val & 0xFF00)>>8;
  byte[2] = (val & 0xFF0000)>>16;
  byte[3] = (val & 0xFF000000)>>24;
}

UINT32 UINT32::operator++(int) // Postfix
{
  UINT32 val_before(*this); 
  operator=(*this + 1);
  return val_before;
}
 
UINT32 UINT32::operator--(int) // Postfix
{
  UINT32 val_before(*this); 
  operator=(*this - 1);
  return val_before;
}

void UINT32::operator/=(const UINT32 &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __LWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

    operator=(*this / i);
}

void UINT32::operator/=(const __ULWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __WORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __SWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __UWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __USWORD__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / i);
}

void UINT32::operator/=(const __SBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__ULWORD__)i);
}

void UINT32::operator/=(const __UBYTE__ &i)
{
  if(i == 0)
#ifdef CPP_EXCEPTIONS
    throw CDivideByZero();
#else
    Error->SignalException(EHandler::DivideByZero);
#endif

  operator=(*this / (__ULWORD__)i);
}

int operator==(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() == b.PackBits();
}

int operator==(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __LWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __ULWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __WORD__ &al, const UINT32 &b)
{
  return al == b.PackBits();
}

int operator==(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __SWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __UWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __USWORD__ &bl)
{
  return  a.PackBits() == bl;
}

int operator==(const __USWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl;
}

int operator==(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits(); 
}

int operator==(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl;
}

int operator==(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits(); 
}

int operator!=(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() != b.PackBits();
}

int operator!=(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __LWORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __ULWORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __WORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __SWORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __UWORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __USWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __USWORD__ &al, const UINT32 &b)
{
  return al != b.PackBits();
}

int operator!=(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() != (__ULWORD__)bl;
}

int operator!=(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al != b.PackBits();
}

int operator!=(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() != (__ULWORD__)bl;
}

int operator!=(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al != b.PackBits();
}

int operator<(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() < b.PackBits();
}

int operator<(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __LWORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __ULWORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __WORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __SWORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __UWORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __USWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __USWORD__ &al, const UINT32 &b)
{
  return al < b.PackBits();
}

int operator<(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() < (__ULWORD__)bl;
}

int operator<(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al < b.PackBits();
}

int operator<(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() < (__ULWORD__)bl;
}

int operator<(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al < b.PackBits();
}

int operator>(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() > b.PackBits();
}

int operator>(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __LWORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __ULWORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __WORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __SWORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __UWORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __USWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __USWORD__ &al, const UINT32 &b)
{
  return al > b.PackBits();
}

int operator>(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() > (__ULWORD__)bl;
}

int operator>(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al > b.PackBits();
}

int operator>(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() > (__ULWORD__)bl;
}

int operator>(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al > b.PackBits();
}

int operator<=(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() < b.PackBits();
}

int operator<=(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __LWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __ULWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __WORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __SWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __UWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __USWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __USWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl ||  a.PackBits() < (__ULWORD__)bl;
}

int operator<=(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits() || (__ULWORD__)al < b.PackBits();
}

int operator<=(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl ||  a.PackBits() < (__ULWORD__)bl;
}

int operator<=(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits() || (__ULWORD__)al < b.PackBits();
}

int operator>=(const UINT32 &a, const UINT32 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() > b.PackBits();
}

int operator>=(const UINT32 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __LWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __ULWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __WORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __WORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __SWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __SWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __UWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __UWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __USWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __USWORD__ &al, const UINT32 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const UINT32 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl || a.PackBits() > (__ULWORD__)bl;
}

int operator>=(const __SBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits() || (__ULWORD__)al > b.PackBits();
}

int operator>=(const UINT32 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULWORD__)bl || a.PackBits() > (__ULWORD__)bl;
}

int operator>=(const __UBYTE__ &al, const UINT32 &b)
{
  return (__ULWORD__)al == b.PackBits() || (__ULWORD__)al > b.PackBits();
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
