// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testi32.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/05/97  
// Date Last Modified: 12/17/97
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the INT32 class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "int32.hpp"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void SkipToEol(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

template<class TYPEX, class TYPEY>
inline void OperatorTest(const TYPEX &x, const TYPEY &y)
{
  char *tf[2] = {"FALSE", "TRUE"};
  cout << endl;
  cout << "Value x = " << x << ", Value y = " << y << endl;
  TYPEX z;
  cout << x << " += " << y << " = "; z = x; z += y; cout << z << endl;
  cout << x << " -= " << y << " = "; z = x; z -= y; cout << z << endl;
  cout << x << " *= " << y << " = "; z = x; z *= y; cout << z << endl;
  cout << x << " /= " << y << " = "; z = x; z /= y; cout << z << endl;
  cout << x << " * " << y << " = " ; z = (x * y); cout << z << endl;
  cout << x << " / " << y << " = " ; z = (x / y); cout << z << endl;
  cout << x << " + " << y << " = " ; z = (x + y); cout << z << endl;
  cout << x << " - " << y << " = " ; z = (x - y); cout << z << endl;
  cout << x << " == " << y << " = " << tf[(x == y)] << endl;
  cout << x << " != " << y << " = " << tf[(x != y)] << endl;
  cout << x << " <= " << y << " = " << tf[(x <= y)] << endl;
  cout << x << " >= " << y << " = " << tf[(x >= y)] << endl;
  cout << x << " < " << y << " = " << tf[(x < y)] << endl;
  cout << x << " > " << y << " = " << tf[(x > y)] << endl;
  cout << x << "++ = "; z = x; z++; cout << z << endl;
  cout << x << "-- = "; z = x; z--; cout << z << endl; 
  cout << "++" << x << " = "; z = x; ++z; cout << z << endl;
  cout << "--" << x << " = "; z = x; --z; cout << z << endl;
}

int main()
{
  INT32 a = LWORDPositiveLimit;
  cout << "INT32 positive limit = " << a << endl;

  INT32 b(LWORDNegitiveLimit);
  cout << "INT32 negitive limit = " << b << endl;

  INT32 c;

  c = ULWORDLimit;
  cout << "Assigning INT32 unsigned limit: " << c << endl;

  pause();
  
  cout << "Testing INT32 copy consturctor..." << endl;
  INT32 d(a);
  cout << d << endl;

  cout << endl;
  cout << "Testing INT32 assignment operator..." << endl;
  INT32 e;
  e = a;
  cout << e << endl;

  pause();

  cout << "Testing overloaded operators (INT32, INT32)..." << endl;
  __LWORD__ buf1, buf2, al, bl;
  
  cout << "Enter first integer: ";
  cin >> buf1;
  if(cin) {
    a = buf1;
    al = buf1;
    cout << "Enter second integer: ";
    cin >> buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }
  if(cin) {
    b = buf2;
    bl = buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }

  SkipToEol(cin);
    
  cout << endl;
  
  OperatorTest(a, b);

  pause();

  cout << "Testing overloaded operators (INT32, __LWORD__)..." << endl;
  OperatorTest(a, bl);

  pause();

  cout << "Testing overloaded operators (__LWORD__, INT32)..." << endl;
  OperatorTest(al, b);
  
  pause();

  cout << "Testing overloaded operators (INT32, __WORD__)..." << endl;
  OperatorTest(a, (__WORD__)bl);

  pause();

  cout << "Testing overloaded operators (__WORD__, INT32)..." << endl;
  OperatorTest((__WORD__)al, b);

  pause();

  cout << "Testing overloaded operators (INT32, __SWORD__)..." << endl;
  OperatorTest(a, (__SWORD__)bl);

  pause();

  cout << "Testing overloaded operators (__SWORD__, INT32)..." << endl;
  OperatorTest((__SWORD__)al, b);

  pause();
  
  cout << "Testing overloaded operators (INT32, __UWORD__)..." << endl;
  OperatorTest(a, (__UWORD__)bl);

  pause();

  cout << "Testing overloaded operators (__UWORD__, INT32)..." << endl;
  OperatorTest((__UWORD__)al, b);

  pause();

  cout << "Testing overloaded operators (INT32, __USWORD__)..." << endl;
  OperatorTest(a, (__USWORD__)bl);

  pause();

  cout << "Testing overloaded operators (__USWORD__, INT32)..." << endl;
  OperatorTest((__USWORD__)al, b);

  pause();
  
  cout << "Testing overloaded operators (INT32, __SBYTE__)..." << endl;
  OperatorTest(a, 'B');

  pause();

  cout << "Testing overloaded operators (__SBYTE__, INT32)..." << endl;
  OperatorTest('A', b);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


