#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: HP C++ A.10.24 compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 05/28/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
#
# To get the current compiler version number enter the 
# following command:
# 
# 	% what /opt/CC/bin/CC
#
# NOTE: Edit the unix.env path to change the path setting
# for the wxWindows GUI library installation path
# ---------------------------------------------------------------

# Set the wxWindows GUI library installation path marco
include ../../../env/wx_unix.env

# All common UNIX compiler flags and options are now in
# this central makefile.
include $(WXDIR)/src/make.env

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base 

# Setup define macros
DEFMACS = -D__wxWINDOWS__ -D__USE_DTYPES_CONSTANTS__

# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld   # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= $(CPPFLAGS)  $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c
OUTPUT = -o
LINK_FLAGS = $(LDFLAGS) 
LINK_LIBS = $(MOTIFLDLIBS)

# Build dependency rules
# ===============================================================
EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

INT32_DEP = $(BASE_PATH)int32.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

UINT32_DEP = $(BASE_PATH)uint32.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

INT16_DEP = $(BASE_PATH)int16.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

UINT16_DEP = $(BASE_PATH)uint16.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

FLOAT64_DEP = $(BASE_PATH)float64.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp 

TESTPROG_DEP = $(BASE_PATH)float64.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp $(BASE_PATH)int32.hpp $(BASE_PATH)uint32.hpp \
	$(BASE_PATH)int16.hpp $(BASE_PATH)uint16.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

int32.o:	$(BASE_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)int32.cpp

uint32.o:	$(BASE_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)uint32.cpp

int16.o:	$(BASE_PATH)int16.cpp $(INT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)int16.cpp

uint16.o:	$(BASE_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)uint16.cpp

float64.o:	$(BASE_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)float64.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(EHANDLER_PATH)ehandler.cpp

# Make the executable
OBJECTS = testprog.o ehandler.o int32.o uint32.o int16.o \
	uint16.o float64.o

$(PROJECT):	$(OBJECTS) $(WXLIB)
	$(CPP) $(COMPILE_FLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) \
	$(LINK_FLAGS) $(LINK_LIBS) 

# ===============================================================
# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
