#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 05/28/1998
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup wxWindows for MSVC 4.0
!include ..\..\..\env\wx_msvc.env

!include $(WXDIR)\src\ntwxwin.mak

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/

ADD_INC_PATHS = /I../base /I../../ehandler/base 

# Setup define macros
DEFMACS = /D__X86__ /D__wxWINDOWS__ /D__USE_DTYPES_CONSTANTS__

# Define macros for compiler and linker
AC     = cl   # ANSI c compiler
CPP    = cl   # C++ compiler
LINKER = link # Linker

# Resource compiler for MSVC
RC = rc

# Compiler and linker flags 
COMPILE_FLAGS= $(CPPFLAGS2) $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LINK_FLAGS = $(LINKFLAGS)
LINK_LIBS = $(LIBS)

# Build dependency rules
# ===============================================================
EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

INT32_DEP = $(BASE_PATH)int32.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

UINT32_DEP = $(BASE_PATH)uint32.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

INT16_DEP = $(BASE_PATH)int16.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

UINT16_DEP = $(BASE_PATH)uint16.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp

FLOAT64_DEP = $(BASE_PATH)float64.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp 

TESTPROG_DEP = $(BASE_PATH)float64.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(BASE_PATH)dtypes.hpp $(BASE_PATH)int32.hpp $(BASE_PATH)uint32.hpp \
	$(BASE_PATH)int16.hpp $(BASE_PATH)uint16.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

int32.obj:	$(BASE_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)int32.cpp

uint32.obj:	$(BASE_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)uint32.cpp

int16.obj:	$(BASE_PATH)int16.cpp $(INT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)int16.cpp

uint16.obj:	$(BASE_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)uint16.cpp

float64.obj:	$(BASE_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)float64.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.res:	testprog.rc $(WXDIR)\include\msw\wx.rc
	$(RC) -r /i$(WXDIR)\include\msw /i$(WXDIR)\contrib\fafa -fo$@ \
	testprog.rc

# Make the executable
OBJECTS = testprog.obj ehandler.obj int32.obj uint32.obj int16.obj \
	uint16.obj float64.obj

RCS = testprog.res

$(PROJECT).exe:	$(DUMMYOBJ) $(OBJECTS) $(RCS) $(WXLIB)
	$(LINKER) $(LINK_FLAGS) $(DUMMYOBJ) $(OBJECTS) $(RCS) \
	$(LINK_LIBS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .RES files from working directory...
	if exist *.res del *.res 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


