// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// C++ Compiler Used: MSVC40 
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 05/26/1998 
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a a test program for the VBD INT32 and FLOAT64 classes
built using the wxWindows 1.68 GUI library. 

NOTE: The UINT32, INT16, and UINT16 classes are provided for
use in database applications but are not tested in this
application. Use the console based test program to test
these classes.
*/
// ----------------------------------------------------------- // 
#include <stdlib.h> 
#include "ehandler.hpp"
#include "dtypes.hpp"
#include "int32.hpp"
#include "uint32.hpp"
#include "int16.hpp"
#include "uint16.hpp"
#include "float64.hpp"

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx_prec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx.h"
#endif

// User input functions
char *GetString(char *Message = "Enter a string",
		char *Caption = "String Input");
int GetInt();
long GetLong();
double GetFloat();

// wxWindows Objects
wxTextWindow *textWin = NULL;

// File menu functions
void TESTI32(wxTextWindow& textWin);
void TESTF64(wxTextWindow& textWin);

// View menu functions
void Clear(wxTextWindow& textWin);

// Define a new application type
class MyApp: public wxApp
{ public:
    wxFrame *OnInit(void);
};

// Define a new frame type
class MyFrame: public wxFrame
{ public:
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    void OnMenuCommand(int id);
    Bool OnClose(void) { return TRUE; }
};

// Identification for the all main menu functions
enum {
  FILE_QUIT = 1,
  FILE_TESTI32,
  FILE_TESTF64,
  VIEW_CLEAR,
  HELP_ABOUT
};

// Program name displayed in main frame window
const char *ProgName = "Test program";

// This statement initializes the whole application and calls OnInit
MyApp myApp;

// A macro needed for some compilers (AIX) that need 'main' to be defined
// in the application itself.
IMPLEMENT_WXWIN_MAIN

// `Main program' equivalent, creating windows and returning main app frame
wxFrame *MyApp::OnInit(void)
{
  // Create the main frame window
  MyFrame *frame = new MyFrame(NULL, (char *)ProgName, 50, 50, 400, 300);

  // Give it an icon
#ifdef wx_msw
  frame->SetIcon(new wxIcon("vbdbase"));
#endif
#ifdef wx_x
  frame->SetIcon(new wxIcon("vbdbase.xbm"));
#endif

  // File menu 
  wxMenu *file_menu = new wxMenu;
  file_menu->Append(FILE_TESTI32, "Test INT32 Class");
  file_menu->Append(FILE_TESTF64, "Test FLOAT64 Class");
  file_menu->AppendSeparator();
  file_menu->Append(FILE_QUIT, "E&xit");

  // View menu
  wxMenu *view_menu = new wxMenu;
  view_menu->Append(VIEW_CLEAR, "&Clear Window");


  // Help menu
  wxMenu *help_menu = new wxMenu;
  help_menu->Append(HELP_ABOUT, "&About");
  
  // Make all the menu bars  
  wxMenuBar *menu_bar = new wxMenuBar;
  menu_bar->Append(file_menu, "&File");
  menu_bar->Append(view_menu, "&View");
  menu_bar->Append(help_menu, "&Help");
  frame->SetMenuBar(menu_bar);
  
  textWin = new wxTextWindow(frame, 0, 0, 400, 400);

  // Show the frame
  frame->Show(TRUE);

  // Return the main frame window
  return frame;
}

MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{
  // My frame constructor
}

void MyFrame::OnMenuCommand(int id)
// Intercept menu commands
{
  switch (id) {
    case FILE_QUIT:
      if (OnClose()) delete this;
	break;

    case FILE_TESTI32:
      TESTI32(*textWin);
      break;

    case FILE_TESTF64:
      TESTF64(*textWin);
      break;

    case VIEW_CLEAR:
      Clear(*textWin);
      break;

    case HELP_ABOUT:
      wxMessageBox("VBD Data Types test program",
		   "About testprog", wxOK|wxCENTRE);
      break;
  }
}

void TESTI32(wxTextWindow& textWin)
{
  textWin.Clear();
  INT32 a = LWORDPositiveLimit;
  textWin << "INT32 positive limit = " << a << "\n";

  INT32 b(LWORDNegitiveLimit);
  textWin << "INT32 negitive limit = " << b << "\n";

  INT32 c;

  c = ULWORDLimit;
  textWin << "Assigning INT32 unsigned limit: " << c << "\n";

  textWin << "\n";
  
  textWin << "Testing INT32 copy consturctor...\n";
  INT32 d(a);
  textWin << d << "\n";

  textWin << "\n";
  textWin << "Testing INT32 assignment operator...\n";
  INT32 e;
  e = a;
  textWin << e << "\n";

  textWin << "\n";

  textWin << "Testing overloaded operators (INT32, INT32)...\n";
  
  INT32 x = GetLong();
  INT32 y = GetLong();
  INT32 z;

  char *tf[2] = {"FALSE", "TRUE"};
  textWin << "\nValue x = " << x << ", Value y = " << y << "\n";
  textWin << x << " += " << y << " = "; z = x; z += y; textWin << z << "\n";
  textWin << x << " -= " << y << " = "; z = x; z -= y; textWin << z << "\n";
  textWin << x << " *= " << y << " = "; z = x; z *= y; textWin << z << "\n";
  textWin << x << " /= " << y << " = "; z = x; z /= y; textWin << z << "\n";
  textWin << x << " * " << y << " = " ; z = (x * y); textWin << z << "\n";
  textWin << x << " / " << y << " = " ; z = (x / y); textWin << z << "\n";
  textWin << x << " + " << y << " = " ; z = (x + y); textWin << z << "\n";
  textWin << x << " - " << y << " = " ; z = (x - y); textWin << z << "\n";
  textWin << x << " == " << y << " = " << tf[(x == y)] << "\n";
  textWin << x << " != " << y << " = " << tf[(x != y)] << "\n";
  textWin << x << " <= " << y << " = " << tf[(x <= y)] << "\n";
  textWin << x << " >= " << y << " = " << tf[(x >= y)] << "\n";
  textWin << x << " < " << y << " = " << tf[(x < y)] << "\n";
  textWin << x << " > " << y << " = " << tf[(x > y)] << "\n";
  textWin << x << "++ = "; z = x; z++; textWin << z << "\n";
  textWin << x << "-- = "; z = x; z--; textWin << z << "\n"; 
  textWin << "++" << x << " = "; z = x; ++z; textWin << z << "\n";
  textWin << "--" << x << " = "; z = x; --z; textWin << z << "\n";
}

void TESTF64(wxTextWindow& textWin)
{
  textWin.Clear();
  __DPFLOAT__ pi = 3.141592653589793;
  
  FLOAT64 a = pi;
  textWin << "Constructing FLOAT64 object and assigning value...\n";
  textWin << a << "\n";

  textWin << "\n";
  
  textWin << "Testing FLOAT64 general constructor...\n";
  FLOAT64 b(pi);
  textWin << b << "\n";

  textWin << "\n";
  
  textWin << "Testing FLOAT64 copy consturctor..." << "\n";
  FLOAT64 c(a);
  textWin << c << "\n";

  textWin << "\n";

  textWin << "Testing FLOAT64 assignment operator..." << "\n";
  FLOAT64 d;
  d = a;
  textWin << d << "\n";

  textWin << "\n";

  textWin << "Testing overloaded operators (FLOAT64, FLOAT64)..." << "\n";

  FLOAT64 x = GetFloat();
  FLOAT64 y = GetFloat();
  FLOAT64 z;

  char *tf[2] = {"FALSE", "TRUE"};
  textWin << "\nValue x = " << x << ", Value y = " << y << "\n";
  textWin << x << " += " << y << " = "; z = x; z += y; textWin << z << "\n";
  textWin << x << " -= " << y << " = "; z = x; z -= y; textWin << z << "\n";
  textWin << x << " *= " << y << " = "; z = x; z *= y; textWin << z << "\n";
  textWin << x << " /= " << y << " = "; z = x; z /= y; textWin << z << "\n";
  textWin << x << " * " << y << " = " ; z = (x * y); textWin << z << "\n";
  textWin << x << " / " << y << " = " ; z = (x / y); textWin << z << "\n";
  textWin << x << " + " << y << " = " ; z = (x + y); textWin << z << "\n";
  textWin << x << " - " << y << " = " ; z = (x - y); textWin << z << "\n";
  textWin << x << " == " << y << " = " << tf[(x == y)] << "\n";
  textWin << x << " != " << y << " = " << tf[(x != y)] << "\n";
  textWin << x << " <= " << y << " = " << tf[(x <= y)] << "\n";
  textWin << x << " >= " << y << " = " << tf[(x >= y)] << "\n";
  textWin << x << " < " << y << " = " << tf[(x < y)] << "\n";
  textWin << x << " > " << y << " = " << tf[(x > y)] << "\n";
  textWin << x << "++ = "; z = x; z++; textWin << z << "\n";
  textWin << x << "-- = "; z = x; z--; textWin << z << "\n"; 
  textWin << "++" << x << " = "; z = x; ++z; textWin << z << "\n";
  textWin << "--" << x << " = "; z = x; --z; textWin << z << "\n";
}

void Clear(wxTextWindow& textWin)
{
  textWin.Clear();
}

int GetInt()
{
  char *buf = GetString("Enter a integer", "Integer Input");
  return atoi(buf);
}

long GetLong()
{
  char *buf = GetString("Enter a long integer", "Long Integer Input");
  return atol(buf);
}

double GetFloat()
// Get a floating point value
{
  char *buf;
  buf = GetString("Enter a floating point value", "Floating Point Input");
  return atof(buf);
}

char *GetString(char *Message, char *Caption)
{
  return wxGetTextFromUser(Message, Caption, NULL);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

