#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the test program
# C/C++ Compiler Used: HP C++ A.10.24 compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 03/31/1997 
# Date Last Modified: 01/17/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
#
# To get the current compiler version number enter the 
# following command:
# 
# 	% what /opt/CC/bin/CC
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
TERMINAL_PATH = ../../terminal/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../terminal/base

# Setup define macros
DEFMACS = -D__CURSES__ -DCPP_EXCEPTIONS -D__UNIX__

# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= +eh $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c 
OUTPUT = -o
LFLAGS = -lcurses -ltermcap

# Build dependency rules
# ===============================================================
TESTPROG_DEP = $(TERMINAL_PATH)terminal.hpp $(EHANDLER_PATH)ehandler.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

TERMINAL_DEP = $(TERMINAL_PATH)terminal.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

terminal.o:	$(TERMINAL_PATH)terminal.cpp $(TERMINAL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(TERMINAL_PATH)terminal.cpp

# Make the executable
OBJS = testprog.o terminal.o ehandler.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(LFLAGS)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
