// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 03/21/1997 
// Date Last Modified: 01/16/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the exception handler class using
a terminal interface.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <fstream.h>
#include "terminal.hpp"
#include "ehandler.hpp"

#ifdef CPP_EXCEPTIONS
int x, y;

class CTest
{
public:
  CTest() { terminal->Write("Constructing CTest object...", x, ++y); }
  ~CTest() { terminal->Write("Destructing CTest object...", x, ++y); }

public:
  int FOpen(const char *s);

private:
  fstream f;
};

int CTest::FOpen(const char *s)
{
  f.open(s, ios::in|ios::nocreate);
  if(!f) return 0;
  return 1;
}

void TestFunction()
{
  CTest ob;
  terminal->Write("In TestFunction(). Throwing COpenError exception...",
		  x, ++y);
  terminal->AnyKey(x, ++y);
  
  if(!ob.FOpen("ABCDEF")) throw CFileOpenError();  
  // This will automatically call the destructor function during
  // stack unwinding for all loacl objects constructed before
  // the exception was thrown.

  // The context between the throw site and the catch handler
  // is known as the "exception stack frame". 
}

#endif


void MyHandler()
{
  terminal->Write("Handling custom exception...");
}

int main()
{
  terminal->init();   // Initialize the terminal

  terminal->Write("Setting exception for non-fatal (dummy) exception...",
		  0, 0);
  terminal->AnyKey(0, 1);
  
  Error->SetException(EHandler::PathError);

  if(Error->Exception()) Error->DisplayException();

  terminal->ClearScreen();
  terminal->Write("Resetting exception...", 0, 0);
  terminal->AnyKey(0, 2);
  Error->ClearException();
  if(Error->Exception()) Error->DisplayException();

  terminal->ClearScreen();
  terminal->Write("Testing display function...", 0, 0);
  terminal->AnyKey(0, 2);
  Error->DisplayException(EHandler::PathError);

  terminal->ClearScreen();
  terminal->Write("Testing custom exception handler routine...", 0, 0);
  terminal->MoveCursor(0, 2);
  Error->TrapException(MyHandler);

#ifdef CPP_EXCEPTIONS
  terminal->ClearScreen();
  x = y = 0;
  terminal->Write("Testing C++'s built-in exception handling routines", x, y);
  terminal->AnyKey(x, ++y);
  try
    {
      terminal->Write("In try block, calling TestFunction()...", x, ++y);
      TestFunction();
    }

  catch(CFileOpenError err)
    {
      err.SignalException(EHandler::FileOpenError, EHandler::DISPLAY);
    }

  terminal->Write("Resuming program execution here...", x, ++y);
  terminal->AnyKey(x, ++y);
#endif

  ifstream InFile("NOTHING", ios::in|ios::nocreate);

  terminal->ClearScreen();
  terminal->Write("Testing fatal exception...", 0, 0);
  terminal->AnyKey(0, 2);
  if(!InFile) Error->SignalException(EHandler::FileOpenError);

  terminal->ClearScreen(); 
  terminal->finish(); // Restore the terminal before exiting
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
