// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// C++ Compiler Used: MSVC 4.2 
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 05/26/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a a test program for the VBD exception handler class
built using the wxWindows 1.68 GUI library.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 

#include "ehandler.hpp"
#include "wxincs.hpp"


// wxWindows Objects
wxTextWindow *textWin = NULL;

// File menu functions
void Run(wxTextWindow& textWin);

// View menu functions
void Clear(wxTextWindow& textWin);


#ifdef CPP_EXCEPTIONS
class CTest
{
public:
  CTest() { }
  ~CTest() { }

public:
  int FOpen(const char *s);

private:
  fstream f;
};

int CTest::FOpen(const char *s)
{
  f.open(s, ios::in|ios::nocreate);
  if(!f) return 0;
  return 1;
}

void TestFunction()
{
  CTest ob;
  // In TestFunction(). Throwing COpenError exception
  if(!ob.FOpen("ABCDEF")) throw CFileOpenError();  
  // This will automatically call the destructor function during
  // stack unwinding for all loacl objects constructed before
  // the exception was thrown.

  // The context between the throw site and the catch handler
  // is known as the "exception stack frame". 
}

#endif

void MyHandler()
{

}

// Define a new application type
class MyApp: public wxApp
{ public:
    wxFrame *OnInit(void);
};

// Define a new frame type
class MyFrame: public wxFrame
{ public:
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    void OnMenuCommand(int id);
    Bool OnClose(void) { return TRUE; }
};

// Identification for the all main menu functions
enum {
  FILE_QUIT = 1,
  FILE_RUN,
  VIEW_CLEAR,
  HELP_ABOUT
};

// Program name displayed in main frame window
const char *ProgName = "Test program";

// This statement initializes the whole application and calls OnInit
MyApp myApp;

// A macro needed for some compilers (AIX) that need 'main' to be defined
// in the application itself.
IMPLEMENT_WXWIN_MAIN

// `Main program' equivalent, creating windows and returning main app frame
wxFrame *MyApp::OnInit(void)
{
  // Create the main frame window
  MyFrame *frame = new MyFrame(NULL, (char *)ProgName, 50, 50, 400, 300);

  // Give it an icon
#ifdef wx_msw
  frame->SetIcon(new wxIcon("vbdbase"));
#endif
#ifdef wx_x
  frame->SetIcon(new wxIcon("vbdbase.xbm"));
#endif

  // File menu 
  wxMenu *file_menu = new wxMenu;
  file_menu->Append(FILE_RUN, "&Run");
  file_menu->AppendSeparator();
  file_menu->Append(FILE_QUIT, "E&xit");

  // View menu
  wxMenu *view_menu = new wxMenu;
  view_menu->Append(VIEW_CLEAR, "&Clear Window");


  // Help menu
  wxMenu *help_menu = new wxMenu;
  help_menu->Append(HELP_ABOUT, "&About");
  
  // Make all the menu bars  
  wxMenuBar *menu_bar = new wxMenuBar;
  menu_bar->Append(file_menu, "&File");
  menu_bar->Append(view_menu, "&View");
  menu_bar->Append(help_menu, "&Help");
  frame->SetMenuBar(menu_bar);
  
  textWin = new wxTextWindow(frame, 0, 0, 400, 400);

  // Show the frame
  frame->Show(TRUE);

  // Return the main frame window
  return frame;
}

MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{
  // My frame constructor
}

void MyFrame::OnMenuCommand(int id)
// Intercept menu commands
{
  switch (id) {
    case FILE_QUIT:
      if (OnClose()) delete this;
	break;

    case FILE_RUN:
      Run(*textWin);
      break;

    case VIEW_CLEAR:
      Clear(*textWin);
      break;

    case HELP_ABOUT:
      wxMessageBox("Exception Handler test program",
		   "About testprog", wxOK|wxCENTRE);
      break;
  }
}

void Run(wxTextWindow& textWin)
{
  textWin.Clear();
  textWin << "Setting exception for non-fatal (dummy) exception...\n";
  Error->SetException(EHandler::PathError);

  if(Error->Exception()) Error->DisplayException();

  textWin << "\nResetting exception...\n";
  Error->ClearException();
  if(Error->Exception()) Error->DisplayException();
		     
  textWin << "\nTesting non-fatal exception with display off...\n";
  Error->SignalException(EHandler::PathError,
			EHandler::DISPLAY,
			DisplayOff);

  textWin << "\nTesting display function...\n";
  Error->DisplayException(EHandler::PathError);

  textWin << "\nTesting custom exception handler routine...\n";
  Error->TrapException(MyHandler);

#ifdef CPP_EXCEPTIONS  
  textWin << "\nTesting C++'s built-in exception handling routines\n";

  try
    {
      textWin << "In try block, calling TestFunction()...\n";
      TestFunction();
    }

  catch(CFileOpenError err)
    {
      err.SignalException(EHandler::FileOpenError, EHandler::DISPLAY);
    }

  textWin << "Resuming program execution here...\n";
#endif

  char *fname = "NOTHING.XYZ";
  ifstream InFile(fname, ios::in|ios::nocreate);

  textWin << "\nUsing Message() function to display a message...\n";
  if(!InFile) Error->Message("Could not open ", fname, " file!");

  textWin << "\nTesting fatal exception...\n";
  int i = wxMessageBox("This will terminate the program!\nContinue?",
		       "Program Message", wxYES_NO|wxCENTRE);
  if(i == wxYES) 
    if(!InFile) Error->SignalException(EHandler::FileOpenError);
}

void Clear(wxTextWindow& textWin)
{
  textWin.Clear();
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

