// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: persist.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 09/18/1997  
// Date Last Modified: 10/09/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
  
The (P)ersistent base class is used to define the interface 
that makes the object persistent. 
*/
// ----------------------------------------------------------- // 
#include "persist.hpp"

void Persistent::Connect(POD *DB) 
{
  if(!DB->OpenDatabase())
#ifdef CPP_EXCEPTIONS
    throw CNoDatabaseOpen();
#else
    Error->SignalException(EHandler::NoDatabaseOpen);
#endif
    pod = DB;
}

void Persistent::Connect(const POD *DB) 
{
  if(!DB->OpenDatabase())
#ifdef CPP_EXCEPTIONS
    throw CNoDatabaseOpen();
#else
    Error->SignalException(EHandler::NoDatabaseOpen);
#endif
    pod = (POD *)DB;
}

void Persistent::WriteObjHeader(const ObjectHeader &oh, FAU addr)
{
  pod->OpenDatabase()->Write(&oh, sizeof(ObjectHeader), addr);
}

void Persistent::ReadObjHeader(ObjectHeader &oh, FAU addr)
{
  pod->OpenDatabase()->Read(&oh, sizeof(ObjectHeader), addr);
}

__UWORD__ Persistent::StringFileLength(const UString &s)
// Calculates the total number of bytes to be allocated for
// the string in the file.
{
  __UWORD__ len = s.length();
  return len + sizeof(UINT32); 
}

__UWORD__ Persistent::StringFileLength(const char *s)
// Calculates the total number of bytes to be allocated for
// the string in the file.
{
  __UWORD__ len;
  // Ensure at least one byte is alloacted
  if(s) len = strlen(s); else len = 1; 
  return len + sizeof(UINT32); 
}

__UWORD__ Persistent::StringFileLength(char *s)
// Calculates the total number of bytes to be allocated for
// the string in the file.
{
  __UWORD__ len;
  // Ensure at least one byte is alloacted
  if(s) len = strlen(s); else len = 1;
  return len + sizeof(UINT32); 
}

void Persistent::WriteString(const UString &s, FAU addr)
{
  UINT32 len = s.length(); // Record the logical length of the string
  pod->OpenDatabase()->Write(&len, sizeof(UINT32), addr);
  if(addr == CurrAddress)
    pod->OpenDatabase()->Write(s.c_str(), len);
  else
    pod->OpenDatabase()->Write(s.c_str(), len, addr+sizeof(UINT32));  
}

void Persistent::WriteString(const char *s, FAU addr)
{
  UINT32 len;
  const char *null_byte = 0; 
  
  // Record the logical length of the string and ensure at least one
  // byte is written if the char *s == 0
  if(s)
    len = strlen(s);
  else
    len = 1;

  pod->OpenDatabase()->Write(&len, sizeof(UINT32), addr);

  if(s) {
    if(addr == CurrAddress)
      pod->OpenDatabase()->Write(s, len);
    else
      pod->OpenDatabase()->Write(s, len, addr+sizeof(UINT32));
  }
  else {
    if(addr == CurrAddress)
      pod->OpenDatabase()->Write(&null_byte, len);
    else
      pod->OpenDatabase()->Write(&null_byte, len, addr+sizeof(UINT32));
  }
}

void Persistent::WriteString(char *s, FAU addr)
{
  UINT32 len;
  const char *null_byte = 0; 
  
  // Record the logical length of the string and ensure at least one
  // byte is written if the char *s == 0
  if(s)
    len = strlen(s);
  else
    len = 1;

  pod->OpenDatabase()->Write(&len, sizeof(UINT32), addr);

  if(s) {
    if(addr == CurrAddress)
      pod->OpenDatabase()->Write(s, len);
    else
      pod->OpenDatabase()->Write(s, len, addr+sizeof(UINT32));
  }
  else {
    if(addr == CurrAddress)
      pod->OpenDatabase()->Write(&null_byte, len);
    else
      pod->OpenDatabase()->Write(&null_byte, len, addr+sizeof(UINT32));
  }
}

void Persistent::ReadString(UString &s, FAU addr)
{
  UINT32 len ;
  pod->OpenDatabase()->Read(&len, sizeof(UINT32), addr);
  char *buf = new char[len + 1];
  if(addr == CurrAddress)
    pod->OpenDatabase()->Read(buf, len);
  else
    pod->OpenDatabase()->Read(buf, len, addr+sizeof(UINT32));

  buf[len] = '\0'; // String must be null terminated
  s = buf;
  delete buf;
}

char *Persistent::ReadString(FAU addr)
{
  UINT32 len ;
  pod->OpenDatabase()->Read(&len, sizeof(UINT32), addr);
  char *buf = new char[len + 1];

  if(addr == CurrAddress)
    pod->OpenDatabase()->Read(buf, len);
  else
    pod->OpenDatabase()->Read(buf, len, addr+sizeof(UINT32));

  buf[len] = '\0'; // String must be null terminated
  return buf;
}

FAU Persistent::AddObject(int find)
// Will search the entire index file or database for the object
// if find is true.
{
  FAU addr;
  if(find) {
    addr = Find();
    if(!addr) addr = Write();
    return addr;
  }
  addr = Write();
  return addr;
}

void Persistent::DeleteObject(FAU addr)
// Delete the object at the specifed address
{
  pod->OpenDatabase()->Delete(addr);
}

void Persistent::RemoveObject(FAU addr)
// Remove the object at the specifed address
{
  pod->OpenDatabase()->Remove(addr);
}

FAU Persistent::ObjectAddress(int find)
// Will search the entire database for the object if find is true
{
  FAU addr;

  if(find) {
    addr = Find();
    if(!addr) return 0; // Object does not exist
    SetObjectAddress(addr);
    return addr;
  }

  return objectaddress;
}

int Persistent::CompareIndex()
// Used by derived class to compare the Index file
// to the Data file. Returns true if the Index file
// keys match the Data file objects.
{
  // The application specific code must be defined by
  // the derived class.

  // Nothing to do in base class. Always return false.
  return 0;
}

int Persistent::RebuildIndexFile(const char *fname)
// Used by derived class to rebuild the Index file.
// Returns true if the Index file was rebuild with
// no errors
{
  // The application specific code must be defined by
  // the derived class.

  // Nothing to do in base class. Always return false.
  return 0;
}

int Persistent::AddKey(EntryKey &key, int flush)
{
  return pod->Index()->Add(key, flush);
}

int Persistent::FindKey(EntryKey &key, int full_search)
{
  if(full_search) return pod->Index()->FullSearch(key);
  return pod->Index()->Search(key);
}

int Persistent::RemoveKey(EntryKey &key, int flush)
{
  return pod->Index()->Remove(key, flush);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
