#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 09/18/1997 
# Date Last Modified: 09/24/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
POD_PATH = ../../pod/base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
VBDFILE_PATH = ../../vbdfile/base/
USTRING_PATH = ../../ustring/base/
REFCOUNT_PATH = ../../refcount/base/
BTREE_PATH = ../../btree/base/
CACHE_PATH = ../../cache/base/
PLACENEW_PATH = ../../placenew/base/
CRC32_PATH = ../../crc32/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../dtypes/base \
-I../../vbdfile/base -I../../ustring/base -I../../refcount/base \
-I../../btree/base -I../../cache/base -I../../placenew/base \
-I../../pod/base -I../../crc32/base 

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Setup define macros
# DEFMACS = -D__CONSOLE__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

BUCKET_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BTREE_PATH)mnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)uint32.hpp

CACHE_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BTREE_PATH)mnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)uint32.hpp

CACHEB_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

CACSTATS_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(CACHE_PATH)cacstats.hpp \
	$(DTYPES_PATH)uint32.hpp

CHPTRB_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

MNODE_DEP = $(BTREE_PATH)mnode.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp \
	$(BTREE_PATH)entrykey.hpp

ENTRYKEY_DEP = $(BTREE_PATH)entrykey.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp 

BTREE_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BTREE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(BTREE_PATH)mnode.hpp $(DTYPES_PATH)int32.hpp\
	$(DTYPES_PATH)dtypes.hpp $(BTREE_PATH)entrykey.hpp \
	$(DTYPES_PATH)uint32.hpp

BTREEPRT_DEP = $(CACHE_PATH)bucket.hpp 	$(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp 	$(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BTREE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(BTREE_PATH)mnode.hpp $(DTYPES_PATH)int32.hpp\
	$(DTYPES_PATH)dtypes.hpp $(BTREE_PATH)entrykey.hpp \
	$(BTREE_PATH)btreeprt.hpp $(DTYPES_PATH)uint32.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

FLOAT64_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(CRC32_PATH)crc32.hpp \
	$(DTYPES_PATH)uint32.hpp

VBDREF_DEP = $(VBDFILE_PATH)vbdfile.hpp $(VBDFILE_PATH)vbdref.hpp \
	$(REFCOUNT_PATH)refcount.hpp

POD_DEP = $(POD_PATH)pod.hpp $(CACHE_PATH)bucket.hpp \
	$(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cache.hpp \
	$(CACHE_PATH)cacheb.hpp $(CACHE_PATH)chptrb.hpp \
	$(CACHE_PATH)cactype.hpp $(CACHE_PATH)cacheptr.hpp \
	$(BTREE_PATH)btree.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BTREE_PATH)mnode.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp \
	$(BTREE_PATH)entrykey.hpp $(BTREE_PATH)btree.hpp \
	$(DTYPES_PATH)uint32.hpp

PERSIST_DEP = $(POD_PATH)pod.hpp $(CACHE_PATH)bucket.hpp \
	$(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cache.hpp \
	$(CACHE_PATH)cacheb.hpp $(CACHE_PATH)chptrb.hpp \
	$(CACHE_PATH)cactype.hpp $(CACHE_PATH)cacheptr.hpp \
	$(BTREE_PATH)btree.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BTREE_PATH)mnode.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp \
	$(BTREE_PATH)entrykey.hpp $(BTREE_PATH)btree.hpp \
	$(BASE_PATH)persist.hpp $(DTYPES_PATH)uint32.hpp 

PART_DEP = $(POD_PATH)pod.hpp $(CACHE_PATH)bucket.hpp \
	$(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cache.hpp \
	$(CACHE_PATH)cacheb.hpp $(CACHE_PATH)chptrb.hpp \
	$(CACHE_PATH)cactype.hpp $(CACHE_PATH)cacheptr.hpp \
	$(BTREE_PATH)btree.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BTREE_PATH)mnode.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp \
	$(BTREE_PATH)entrykey.hpp $(BTREE_PATH)btree.hpp \
	$(BASE_PATH)persist.hpp part.hpp $(DTYPES_PATH)uint32.hpp 

USTRING_DEP = $(USTRING_PATH)ustring.hpp 

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp $(DTYPES_PATH)int32.hpp \
        $(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(USTRING_PATH)ustring.hpp $(POD_PATH)pod.hpp \
	$(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cacheptr.hpp \
	$(CACHE_PATH)cactype.hpp $(BTREE_PATH)btree.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BTREE_PATH)mnode.hpp \
	$(BTREE_PATH)entrykey.hpp $(BTREE_PATH)btreeprt.hpp \
	$(CACHE_PATH)cacstats.hpp $(POD_PATH)pod.hpp \
	$(BASE_PATH)persist.hpp part.hpp $(DTYPES_PATH)uint32.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

mnode.o:	$(BTREE_PATH)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)mnode.cpp

entrykey.o:	$(BTREE_PATH)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)entrykey.cpp

btreeprt.o:	$(BTREE_PATH)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btreeprt.cpp

btree.o:	$(BTREE_PATH)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BTREE_PATH)btree.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdref.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

float64.o:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

pod.o:    $(POD_PATH)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(POD_PATH)pod.cpp

persist.o:    $(BASE_PATH)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)persist.cpp

part.o:	part.cpp $(PART_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) part.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = ehandler.o float64.o int32.o vbdfile.o \
	testprog.o ustring.o pod.o cacheb.o chptrb.o \
	btree.o mnode.o bucket.o cache.o vbdref.o \
	entrykey.o btreeprt.o cacstats.o persist.o \
	part.o crc32.o uint32.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing any test file created...
	rm -f *.pod
	rm -f *.btx
	rm -f *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
