// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 02/28/1997 
// Date Last Modified: 01/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This program uses the overloaded new operator in placenew.hpp
to construct objects in-place at a user defined address. In the
program explicit destructor calls are used to destroy the objects
constructed. Note that an explicit destructor call should never
be called twice for an object or be called for objects that reside
on the heap. Objects that reside on the heap can be destroyed using
the delete operator.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "placenew.hpp"

const unsigned Len = 255; // String length of the fixed string

class FString 
{ 
public:
  FString() {
    cout << "Default FString constructor called" << endl; 
    Clear();
  }

  FString(char *s) {
    cout << "General FString constructor called" << endl;
    Clear();
    Store(s);
  }

  ~FString() { cout << "FString destructor called" << endl; }    

  FString(const FString &s) {
    cout << "FString copy constructor called" << endl;
    Copy(s);
  }

  FString &operator=(const FString &s) {
    cout << "FString assignment operator called\n";
    if(this != &s) Copy(s); 
    return *this;
  }

public:
  void Store(char *s);
  void Clear();
  void Copy(const FString &s);
  char *c_str();
  
public:
  friend int operator==(const FString &a, const FString &b) {
    return strcmp(a.str, b.str) == 0;
  }

  friend int operator<(const FString &a, const FString &b) {
    return strcmp(a.str, b.str) < 0;
  }

  friend int operator>(const FString &a, const FString &b) {
    return strcmp(a.str, b.str) > 0;
  }

  friend int operator!=(const FString &a, const FString &b) {
    return strcmp(a.str, b.str) != 0;
  }
  
  friend ostream &operator<<(ostream &os, const FString &s) {
    return os.write(s.str, strlen(s.str));
  }

  friend istream &operator>>(istream &os, FString &s) {
    os >> setw(strlen(s.str)) >> s.str;
    return os;
  }
	       
private:
  char str[Len];
};

void FString::Clear()
{
  for(unsigned i = 0; i < Len; i++)
    str[i] = 0;
}

void FString::Store(char *s)
{
  char *buf = new char[Len+1];
  buf[Len] = '\0';
  memcpy(buf, s, Len);
  for(unsigned i = 0; i < Len; i++)
    str[i] = buf[i];
}

void FString::Copy(const FString &s)
{
  Clear();

  for(unsigned i = 0; i < Len; i++)
    str[i] = s.str[i];
}

char *FString::c_str()
{
  char *buf = new char[Len+1];
  buf[Len] = '\0';
  memcpy(buf, str, Len);
  return buf;
}

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  // Allocate an array of characters as opposed to FString objects
  // to ensure that array will have unconstructed bits initially.    
  char array[2*sizeof(FString)];

  cout << "Constructing an object in-place at address array[0]..." << endl;
  new(&array[0]) FString;

  void *p = &array[0]; // Obtain the address of the array[0] element
  
  // Pointer to FString object initialized by casting void pointer to
  // an FString pointer.
  FString *ptr = (FString *)p;
  
  // Initialize object at address ptr
  ptr->Store("This is the object's data at address array[0]") ;
  cout << *ptr << endl;
  
  cout << "Destroying the object with an explicit destructor call..." << endl;
  ptr->FString::~FString();

  pause();

  cout << "Constructing and initializing an object in-place at array[1]..."
       << endl;

  p = new(&array[1]) FString("This is the object's data at address array[1]") ;
  ptr = (FString *)p;
  
  cout << *ptr << endl;

  cout << "Destroying the object with an explicit destructor call..." << endl;
  ptr->FString::~FString();
    
  pause();
  
  cout << "Creating a new FString object named str..." << endl;
  FString str("This is the object's data at address array[2]");
  
  cout << "Copy constructing an object in-place at address array[2]..."
       << endl;

  p = new(&array[2]) FString(str);
  ptr = (FString *)p;

  cout << *ptr << endl;
  
  cout << "Destroying the object with an explicit destructor call..." << endl;
  ptr->FString::~FString();

  cout << endl;
  cout << "Automatic destructor call to destroy object str..." << endl;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
