// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: pod.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 09/18/1997 
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The (P)ersistent (O)bject (D)atabase manager is used to manage
the file pointers to VBD files.
*/
// ----------------------------------------------------------- // 
#include "pod.hpp"

// File extensions for data and index files
const char *data_ext = ".pod"; // Data file created with POD/Persist classes
const char *idx_ext = ".btx";  // Index file created with the Btree class

// NOTE: The index file will always be created with the Btree class
// The DTree class is provided for testing purposes.
// const char *idx_ext = ".dtx";  // Index file created with the DTree class

POD::POD(UString &fname, VBDFile::AccessMode mode,
	 int use_index, int cache_size)
{
  // Do not use any file extensions when creating or opening file.
  // Both data and index will share the same name with different
  // file extensions. 
  UString DataFile(fname+data_ext);
  UString IndexFile(fname+idx_ext);

  using_index = use_index;
  DBindex = new Btree(cache_size);
  
  if(!VBDFile::Exists(DataFile.c_str())) {
    Create(fname);
    exists = 0;
    if(using_index) {
      CreateIndex(fname);
      rebuild_index = 0;
      DBindex->Connect(openindexfile, 1);
    }
  }
  else {
    Open(fname, mode); // Open the data file
    exists = 1;
    if(using_index) { // Open the index file if it exist
      if(!VBDFile::Exists(IndexFile.c_str())) {
	CreateIndex(fname);
	rebuild_index = 1;
	DBindex->Connect(openindexfile, 1);
      }
      else {
	OpenIndex(fname, mode);
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 0);
      }
    }
  }
}

POD::POD(const char *fname, VBDFile::AccessMode mode,
	 int use_index, int cache_size)
{
  // Do not use any file extensions when creating or opening file.
  // Both data and index will share the same name with different
  // file extensions. 
  UString DataFile(fname);
  UString IndexFile(fname);

  // Append the file extensions
  DataFile = DataFile + data_ext;
  IndexFile = IndexFile + idx_ext;

  using_index = use_index;
  DBindex = new Btree(cache_size);
  
  if(!VBDFile::Exists(DataFile.c_str())) {
    Create(fname);
    exists = 0;
    if(using_index) {
      CreateIndex(fname);
      rebuild_index = 0;
      DBindex->Connect(openindexfile, 1);
    }
  }
  else {
    Open(fname, mode); // Open the data file
    exists = 1;
    if(using_index) { // Open the index file if it exist
      if(!VBDFile::Exists(IndexFile.c_str())) {
	CreateIndex(fname);
	rebuild_index = 1;
	DBindex->Connect(openindexfile, 1);
      }
      else {
	OpenIndex(fname, mode);
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 0);
      }
    }
  }
}

POD::POD(UString &dfname, UString &ifname, VBDFile::AccessMode mode, 
      int use_index, int cache_size)
// 02/04/1998 This constructor was added to allow an application
// to used different index and data files. No file extensions will
// be added to the file names.
{
  using_index = use_index;
  DBindex = new Btree(cache_size);
  
  if(!VBDFile::Exists(dfname.c_str())) {
    Create(dfname, 0); // Do not add file extension
    exists = 0;
    if(using_index) {
      if(!VBDFile::Exists(ifname.c_str())) {
	// Do not overwrite the index file
	CreateIndex(ifname, 0); // Do not add file extension 
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 1);
      }
    }
  }
  else {
    Open(dfname, mode, 0); // Open the data file
    exists = 1;
    if(using_index) { // Open the index file if it exist
      if(!VBDFile::Exists(ifname.c_str())) {
	CreateIndex(ifname, 0);
	rebuild_index = 1;
	DBindex->Connect(openindexfile, 1);
      }
      else {
	OpenIndex(ifname, mode, 0);
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 0);
      }
    }
  }
}

POD::POD(const char *dfname, const char *ifname, VBDFile::AccessMode mode,
      int use_index, int cache_size)
// 02/04/1998 This constructor was added to allow an application
// to used different index and data files. No file extensions will
// be added to the file names.
{
  using_index = use_index;
  DBindex = new Btree(cache_size);
  
  if(!VBDFile::Exists(dfname)) {
    Create(dfname, 0); // Do not add file extension
    exists = 0;
    if(using_index) {
      if(!VBDFile::Exists(ifname)) {
	// Do not overwrite the index file
	CreateIndex(ifname, 0); // Do not add file extension 
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 1);
      }
    }
  }
  else {
    Open(dfname, mode, 0); // Open the data file
    exists = 1;
    if(using_index) { // Open the index file if it exist
      if(!VBDFile::Exists(ifname)) {
	CreateIndex(ifname, 0);
	rebuild_index = 1;
	DBindex->Connect(openindexfile, 1);
      }
      else {
	OpenIndex(ifname, mode, 0);
	rebuild_index = 0;
	DBindex->Connect(openindexfile, 0);
      }
    }
  }
}

int POD::Connect(VBDFilePtr &fp)
{
  if(!fp) return 0;
  opendatabase = fp; 
  if(opendatabase->IsOK()) return 1; else return 0;
}

int POD::ConnectIndex(VBDFilePtr &fp)
{
  if(!fp) return 0;
  openindexfile = fp; 
  if(openindexfile->IsOK()) return 1; else return 0;
}

int POD::Create(const UString &fname, int add_ext)
{
  UString DataFile(fname);

  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) DataFile = DataFile + data_ext;

  Disconnect();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Create(DataFile.c_str());
  if (!tmp->IsOK()) return 0;
  return Connect(tmp);
}

int POD::CreateIndex(const UString &fname, int add_ext)
{
  UString IndexFile(fname);
  
  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) IndexFile = IndexFile + idx_ext;

  DisconnectIndex();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Create(IndexFile.c_str(), sizeof(BtreeHeader));
  if (!tmp->IsOK()) return 0;
  return ConnectIndex(tmp);
}

int POD::Create(const char *fname, int add_ext)
{
  UString DataFile(fname);

  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) DataFile = DataFile + data_ext;
  
  Disconnect();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Create(DataFile.c_str());
  if (!tmp->IsOK()) return 0;
  return Connect(tmp);
}

int POD::CreateIndex(const char *fname, int add_ext)
{
  UString IndexFile(fname);
  
  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) IndexFile = IndexFile + idx_ext;

  DisconnectIndex();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Create(IndexFile.c_str(), sizeof(BtreeHeader));
  if (!tmp->IsOK()) return 0;
  return ConnectIndex(tmp);
}

void POD::Disconnect()
// Disconnects the database from the file.
{
  if(opendatabase) {
    opendatabase->Close();
  }
}

void POD::DisconnectIndex()
// Disconnects the database from the file.
{
  if(DBindex) {
    DBindex->Disconnect();
  }

  if(openindexfile) {
    openindexfile->Close();
  }
}

void POD::Flush()
{
  if (opendatabase->IsOK()) {
     if (opendatabase->ReadyForWriting()) {
        opendatabase->Flush();
     }
  }
}

int POD::Open(const UString &fname, VBDFile::AccessMode mode, int add_ext)
{
  UString DataFile(fname);

  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) DataFile = DataFile + data_ext;

  Disconnect();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Open(DataFile.c_str(), mode);
  if (!tmp->IsOK()) return 0;
  return Connect(tmp);
}

int POD::Open(const char *fname, VBDFile::AccessMode mode, int add_ext)
{
  UString DataFile(fname);

  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) DataFile = DataFile + data_ext;

  Disconnect();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Open(DataFile.c_str(), mode);
  if (!tmp->IsOK()) return 0;
  return Connect(tmp);
}

int POD::OpenIndex(const UString &fname, VBDFile::AccessMode mode, int add_ext)
{
  UString IndexFile(fname);
  
  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) IndexFile = IndexFile + idx_ext;
  
  DisconnectIndex();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Open(IndexFile.c_str(), mode);
  if (!tmp->IsOK()) return 0;
  return ConnectIndex(tmp);
}

int POD::OpenIndex(const char *fname, VBDFile::AccessMode mode, int add_ext)
{
  UString IndexFile(fname);
  
  // Both data and index will share the same name with different
  // file extensions if add_ext is true.
  if(add_ext) IndexFile = IndexFile + idx_ext;
  
  DisconnectIndex();
  VBDFilePtr tmp(new VBDFile);
  VBDFilePtr nul = 0; // Used to satisfy overloaded == in RefCount class 
  if (tmp == nul) return 0;
  tmp->Open(IndexFile.c_str(), mode);
  if (!tmp->IsOK()) return 0;
  return ConnectIndex(tmp);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
