// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: pod.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 09/18/1997 
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The (P)ersistent (O)bject (D)atabase manager is used to manage
the file pointers to VBD files.

Changes:
================================================================
02/03/1998 - Modified POD constructors, Open() and Create()
functions. Modified versions will now automatically add the
file extension by default to the database and index files.
Changed by: Doug Gaer

02/03/1998 - Added Btree class to create index files.
Changed by: Doug Gaer

02/03/1998 - Modified POD constructors and added new functions
to work with index files.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __POD_HPP
#define __POD_HPP

#include "vbdfile.hpp"
#include "ustring.hpp"
#include "btree.hpp"

// (P)ersistent (O)bject (D)atabase manager class
class POD
{
public:
  // 02/03/1998 These constructors were modified to work with index 
  // files. These constructors will automatically add file extensions 
  // to the database and index files.
  POD(UString &fname, VBDFile::AccessMode mode = VBDFile::READWRITE,
      int use_index = 0, int cache_size = 8);
  POD(const char *fname, VBDFile::AccessMode mode = VBDFile::READWRITE,
      int use_index = 0, int cache_size = 8);

  // 02/04/1998 These constructors were added to allow an application
  // to used different index and data files. No file extensions will
  // be added to the file names.
  POD(UString &dfname, UString &ifname,
      VBDFile::AccessMode mode = VBDFile::READWRITE,
      int use_index = 0, int cache_size = 8);
  POD(const char *dfname, const char *ifname,
      VBDFile::AccessMode mode = VBDFile::READWRITE,
      int use_index = 0, int cache_size = 8);
  
  // 02/03/1998 Destructor modified to work with index files
  ~POD() { Disconnect(); DisconnectIndex(); }
  
private:
  POD(const POD &ob) { }            // Disallow coping
  void operator=(const POD &ob) { } // Disallow assignment

public:
  int Open(const UString &fname,
	   VBDFile::AccessMode mode = VBDFile::READWRITE, int add_ext = 1);
  int Open(const char *fname,
	   VBDFile::AccessMode mode = VBDFile::READWRITE, int add_ext = 1);
  void Disconnect();
  int Create(const UString &fname, int add_ext = 1);
  int Create(const char *fname, int add_ext = 1);
  void Flush();
  void Close() { Disconnect(); }
  int Connect(VBDFilePtr &fp);
  VBDFilePtr OpenDatabase() { return opendatabase; }
  VBDFilePtr OpenDatabase() const { return opendatabase; }
  int Exists() const { return exists; }
  int Exists() { return exists; }

public: // 02/03/1998 Functions added to work with index files
  int OpenIndex(const UString &fname,
		VBDFile::AccessMode mode=VBDFile::READWRITE, int add_ext = 1);
  int OpenIndex(const char *fname,
		VBDFile::AccessMode mode=VBDFile::READWRITE, int add_ext = 1);
  void DisconnectIndex();
  int CreateIndex(const UString &fname, int add_ext = 1);
  int CreateIndex(const char *fname, int add_ext = 1);
  int ConnectIndex(VBDFilePtr &fp);
  VBDFilePtr OpenIndexFile() { return openindexfile; }
  VBDFilePtr OpenIndexFile() const { return openindexfile; }
  int UsingIndex() { return using_index; }
  int UsingIndex() const { return using_index; }
  int RebuildIndex() { return rebuild_index; }
  int RebuildIndex() const { return rebuild_index; }
  Btree *Index() { return DBindex; }
  Btree *Index() const { return DBindex; }

  // Allow appliction to reset rebuild_index member. 
  void ResetIndexRebuild() { rebuild_index = 0; }

  // Tell POD Manager that index file and data file do not match.
  void BuildNewIndex() { rebuild_index = 1; }
  
  // These functions were added to allow the application to enable
  // and disable the index file routines for certain functions.
  void DisableIndex() { using_index = 0; }
  void EnableIndex() { using_index = 1; }

private:
  VBDFilePtr opendatabase;  // VBD file pointer to the data file
  VBDFilePtr openindexfile; // VBD file pointer to the index file
  int exists;               // True if data file already exists

private: // 02/04/1998 Members added to work with index files
  Btree *DBindex;    // Btree for the index file
  int using_index;   // True if using an index file
  int rebuild_index; // True if index file needs to be rebuilt  
};

#endif // __POD_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
