// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 09/18/1997  
// Date Last Modified: 10/07/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the POD class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "pod.hpp"
#include "float64.hpp"
#include "btreeprt.hpp"

class Part
{ 
public:
  Part(INT32 i = 0, FLOAT64 p = 0) { id = i; price = p; }

public:
  FAU ClassID() { return 10241; }
  
public:
  INT32 id; 
  FLOAT64 price;
};

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}
    
int main()
{
  int CacheSize = 15;   // Memory cache size for the index file
  int UseIndexFile = 1; // This application will use an index file

  // Define file access modes used in the application
  VBDFile::AccessMode RWMode = VBDFile::READWRITE;
  VBDFile::AccessMode ROMode = VBDFile::READONLY;
  
  // Test POD constructors that use the same file name
  UString FileName("testfile");      // Testing UString constructor 
  // POD pod(FileName, RWMode); // Not using index file
  // POD pod(FileName.c_str(), RWMode); // Not using index file
  // POD pod(FileName, RWMode, UseIndexFile, CacheSize);
  // POD pod(FileName.c_str(), RWMode, UseIndexFile, CacheSize);
  
  // Test POD constructors that use the different file names
  UString dfname("testfile.pod"); UString ifname("testfile.btx");
  // POD pod(dfname, ifname, RWMode); // Not using index file
  // POD pod(dfname.c_str(), ifname.c_str(), RWMode); // Not using index file
  // POD pod(dfname, ifname, RWMode, UseIndexFile, CacheSize);
  POD pod(dfname.c_str(), ifname.c_str(), RWMode, UseIndexFile, CacheSize);
 
  POD *DB = &pod;
  
  cout << "Data File Reference count = "
       << DB->OpenDatabase()->Count() << endl;

  if(DB->UsingIndex())
  cout << "Index File Reference count = "
       << DB->OpenIndexFile()->Count() << endl;
  
  pause();
  
  FAU addr;
  char *partname = "Screws"; // Arbitrary name of the part to add
  
  if(!DB->Exists()) { // New data and index file were created
    cout << "Adding object to POD file..." << endl;
    Part part(17, 2.97); // In-memory copy of part to be stored
    cout << "Size of object = " << sizeof(Part) << endl;
    addr = DB->OpenDatabase()->Alloc(sizeof(Part)); // Allocate room for part
    cout << "Object's address = " << addr << endl;
    DB->OpenDatabase()->Write(&part, sizeof(Part), addr);
    cout << endl;
    cout << "Adding key named " << partname << " to index file..." << endl;
    if(DB->UsingIndex()) {
      DB->Index()->Add(partname, addr, part.ClassID());
      cout << "Printing index file data..." << endl;
      PrintTree(DB->Index()->GetRoot(), DB->Index());
    }
  }
  else {
    DB->Open(FileName); 
    if(!DB->UsingIndex()) return 0;
    Part buf;
    cout << "Searching index file for part named " << partname << endl;
    if(DB->RebuildIndex()) {
      cout << "Index file needs to be rebuilt." << endl;
      return 0;
    }
    EntryKey e(partname);
    int status = DB->Index()->Search(e);
    if(!status) {
      cout << "Could not find key in index file!" << endl;
      Error->SignalException(EHandler::AssertError);
    }
    cout << "Found " << e.key << " in index file." << endl;
    cout << "Object address = " << e.object_address << endl;
    cout << "Class ID =       " << e.class_id << endl; 

    cout << endl;
    cout << "Reading the object from the POD file..." << endl;
    DB->OpenDatabase()->Read(&buf, sizeof(Part), e.object_address);
    cout << "Part: <" << buf.id << ", " << buf.price << ">" << endl;
  }

  cout << endl;
  cout << "Closing file automatically using VBDFile destructor..." << endl;
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
