// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: pscript.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/17/1997
// Date Last Modified: 11/03/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The PostScriptDrv class is used to create postscript documents.
This version prints postscript documents to a file.
*/
// ----------------------------------------------------------- //   
#ifndef __PSCRIPT_HPP__
#define __PSCRIPT_HPP__

#include <fstream.h>

// Setup postscript defaults
const int DEFAULT_TAB_SIZE = 8;        // Default tab size
const double DEFAULT_POINT_SIZE = 10;  // Default point size (10 pitch)
const double DEFAULT_OFFSET = 0.0;     // Default inches to indent each line
const double DEFAULT_LR_MARGIN = 1.0;  // Default left and right margin offset
const double DEFAULT_TB_MARGIN = 1.0;  // Default top and bottom margin offset
const double PRINTABLE_OFFSET_Y = 25;  // Printable area offset
const double PRINTABLE_OFFSET_X = 25;  // Printable area offset
const double HEADER_OFFSET = 1.0;      // Offset for header and trailer text
const int THICK_LINE_WIDTH = 2;        // Line width for header lines
const int LINE_WIDTH = 1;              // Line width for separator lines

// Setup postscript constants
const char SEP_CHAR = '\001';   // Column separator character 
const int MAXPAGES = 10000;     // Maximum number of pages per job 
const int PS_EOF = 0x04;        // PostScript end of file mark
const int MAX_LINES = 160;      // Maximum lines per page for documents 
const int PIXELS_PER_INCH = 72; // PostScript points per inch     

// Max lines for a unix man page produced by nroff
// nroff is used to format man pages under most variants of UNIX
const int UNIX_MAN_PAGE_LINES = 66;   

// Setup input/output buffer sizes for postscript documents
const int MAX_LINE = 256; // No PostScript line can exceed 256 characters
const int BUFIN = 1024;   // Maximum length of an input line 
const int BUFOUT = (BUFIN * 5);

// Standalone function used to create a custom time string
// for PostScript headers.
void GetSystemTime(char *s, int full_month_name = 1);

const int NumberOfFonts = 13;      // Number of fonts to support

// (P)ostscript (D)river class
class PostScriptDrv
{
public:
  enum PSFonts {
    // Most PostScript products include software for 13 standard fonts:
    // Courier, Times, Helvetica, and Symbol families.
    
    // Courier fonts
    COURIER,              // Courier
    COURIER_BOLD,         // Courier-Bold
    COURIER_OBLIQUE,      // Courier-Oblique
    COURIER_BOLD_OBLIQUE, // Courier-BoldOblique

    // Times-Roman fonts
    TIMES,             // Times-Roman
    TIMES_BOLD,        // Times-Bold
    TIMES_ITALIC,      // Times-Italic
    TIMES_BOLD_ITALIC, // Times-BoldItalic

    // Helvetica fonts
    HELV,                      // Helvetica
    HELV_BOLD,                 // Helvetica-Bold
    HELV_OBLIQUE,              // Helvetica-Oblique
    HELV_BOLD_OBLIQUE,         // Helvetica-BoldOblique

    // Symbol font
    SYMBOL                     // Symbol
  };

  enum PSPaperSizes {
    // Non-metric Traditional Paper Sizes used in Canada and the
    // United States. Sheet sizes accommodate 1/8" (3 mm) head,
    // foot, and fore edge trim margins (width precedes height).
    // Decimal inches multiplied by 25.4 to convert to approximate mm.
    // N.B. Fractional mm measures must be rounded to the nearest
    // whole number.
    LETTER_SIZE,  // 8.5 x 11 inches 
    LEGAL_SIZE,   // 8.5 x 14 inches 
    TABLOID_SIZE, // 11 x 17 inches  

    // ISO/DIN and JIS Standard Paper Sizes Trim sizes in mm.
    // Width precedes height. Sheet sizes accommodate 3 mm head,
    // foot, and fore edge trim margins. To convert to approximate
    // decimal inches, divide measures by 25.4.
    A3_SIZE, // 297mm x 420mm (11.70" X 16.55")
    A4_SIZE  // 210mm x 297mm (8.27" X 11.70")
  };

public:
  PostScriptDrv();
  ~PostScriptDrv() { }
  PostScriptDrv(const PostScriptDrv &ob);
  PostScriptDrv &operator=(const PostScriptDrv &ob);
  
public: // Document setup functions
  void DocumentSetup(double LR_margin = 0, double TB_margin = 0, int man = 0);
  void SetFont(PSFonts font, double size);
  void SetPaperSize(PSPaperSizes size);
  void UseLRMargin() { use_lr_margin = 1; } // Use left and right margins
  void UseTBMargin() { use_tb_margin = 1; } // Use top and bottom margins
  void NoMargins() { use_lr_margin = use_tb_margin = 0; }
  void LandScapeMode() { landscape = 1; }
  void PortraitMode() { landscape = 0; }
  void Copies(int num) { ncopies = num; }
  void SetTabStop(int num) { tabstop = num; }
  int StringLen(char *s, int charWidth);
  int StringLen(const char *s, int charWidth);

public: // Document parameters
  double CharsPerInch() { return chars_per_inch; }
  double CharWidth() { return char_width; }
  char *TextFont() { return text_font; }
  double FontSize() { return font_size; }
  int PageWidth() { return page_width; }
  int PageHeight() { return page_height; }
  int LinesPerPage() { return lines_per_page; }
  int Columns() { return columns; }
  int StartX() { return start_x; }
  int StartY() { return start_y; }
  int NCopies() { return ncopies; }
  int TabStop() { return tabstop; }
  int UsingLRMargin() { return use_lr_margin; }
  int UsingTBMargin() { return use_tb_margin; }
  int GetMode() { return landscape; }    // Returns true if using landscape 

public: // Document header and trailer infomation 
  void UseHeader() { use_header = 1; }
  int UsingHeader() { return use_header; }
  char *HeaderFont() { return header_font; }
  double HeaderFontSize() { return header_font_size; }
  void SetHeaderFont(PSFonts font, double size);
  void SetDocumentName(char *s) { document_name = s; }
  void SetDocumentName(const char *s) { document_name = (char *)s; }
  void SetDateString(char *s) { date_string = s; }
  void SetDateString(const char *s) { date_string = (char *)s; }
  void DrawHeaderLine() { draw_header_line = 1; }
  
public: // Postscript printing functions 
  void Epilogue(ostream &stream, int page_count);
  void EndPage(ostream &stream);
  void StartPage(int n, ostream &stream);
  void drawLine(ostream &stream, int points, int xpos, int ypos);
  void drawThickLine(ostream &stream, int points, int xpos, int ypos);
  void MoveTo(ostream &stream, int x, int y);
  void ChangeFont(ostream &stream, PSFonts font, double size);
  int ConvertTextFile(ifstream &infile, ostream &stream,
		      int wrap = 0, int cut = 1);
  int ProcessText(char *in, ostream &stream, int cut = 1, int filter = 0);
  int PrintLine(char *in, ostream &stream);
  int PrintLine(char *s, unsigned max_len, ofstream &stream);
  
  // Generates the PostScript header and includes the prologue.
  // Arguments are: pn - Program Name, hn - Hostname,
  // cd - Creation Date and un - Username.
  void Prologue(ostream &stream, char *pn = 0, char *hn = 0,
		char *cd = 0, char *un = 0);
  
  // Sets the physical sources and physical destinations for the media
  // source and destination to be used in the printer. These settings
  // are device dependent.
  void MediaSetup(ostream &stream, int duplex = 0, int manualfeed = 0,
		  int use_tray = 0, int tray_number = 0);

private: // Document Settings
  int ncopies;   // Number of copies
  int landscape; // Use landscape instead of portrait if true
  int tabstop;   // Number of spaces per tab
  
private: // Font dependent members
  double chars_per_inch; // Number of charaters per inch
  double char_width;     // Width of each character
  char *text_font;       // Text font for this document
  double font_size;      // Font or point size
  int columns;           // Number of columns
  
private: // Page dependent members
  int page_width;     // Page width for selected paper size
  int page_height;    // Page height for selected paper size
  int use_lr_margin;  // True if using left and right margins
  int use_tb_margin;  // True if using top and bottom margins
  int lines_per_page; // Lines per page   
  int start_x;        // Starting x position 
  int start_y;        // Starting y position 

private: // Page header and trailer infomataion
  int use_header;          // Use page headers and trailers if true
  char *header_font;       // Text font for headers and trailers
  double header_font_size; // Font or point size for page headers
  char *document_name;     // Name of this document
  char *date_string;       // Time and date this document was printed
  int draw_header_line; // Draw line between header and document text if true 

public: // Page processing members 
  int page_count;     // Keeps track of the total number of pages
  int row;            // Keeps track of the number of rows per page
  int line_count;     // Keeps track of the lines per page
};

#endif  // __PSCRIPT_HPP__ 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
