// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: queue.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/22/1997 
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A generic singly linked list based stack queue. This is a
first-in, first-out (FIFO) resizable data structure. Heap
space is allocated and de-allocated with every insert and
extract operation.
*/
// ----------------------------------------------------------- //   
#include "stack.hpp"

template<class TYPE>
class Queue : public Stack<TYPE>
{
public:
  Queue() { }
  Queue(const Queue<TYPE> &X): Stack<TYPE>(X) { }
  void operator=(const Queue<TYPE> &X) { Copy(X); }

public:
  int Insert(const TYPE &X);
  int Extract(TYPE &X);
  void Clear();
  TYPE *Head() { return Top(); }
  const TYPE *Head() const { return Top(); }
};

template<class TYPE>
int Queue<TYPE>::Extract(TYPE &X)
{
  return Pop(X);
}

template<class TYPE>
void Queue<TYPE>::Clear()
{
  Rewind();
}

template<class TYPE>
int Queue<TYPE>::Insert(const TYPE &X)
{
  SNode<TYPE> *ptr = AllocNode(X);
  if(ptr == 0) return 0;
  AttachToBack(ptr);
  return 1;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

