// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: testprog.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/22/1997 
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the generic singly-linked list based
stack queue class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <ctype.h>
#include "queue.hpp"
#include "ustring.hpp"

void SkipToEol(istream &s)
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

template<class TYPE>
inline int Copy(Queue<TYPE> &s)
{
  Queue<TYPE> t;
  t = s;
  cout << "Creating copy of queue:" << endl << endl;
  return 1;
}

template<class TYPE>
inline int Extract(Queue<TYPE> &s)
{
  if (s.IsEmpty()) {
     cout << "Queue empty" << endl;
     return 1;
  }

  TYPE x;

  if (s.Extract(x)) {
     cout << "String extracted is: " << x << endl;
  }
  else {
     cout << "Extract failed" << endl;
  }
  return 1;
}

template<class TYPE>
inline int Front(const Queue<TYPE> &s)
{
  const TYPE *p = s.Head();
  if (p) {
     cout << "Front String is: " << *p << endl;
  }
  else {
     cout << "Queue empty" << endl;
  }
  return 1;
}

int InsertFront(Queue<UString> &s)
{
  UString x;

  cout << "Enter new character string: ";
  cin >> x;
     if (cin) {
        int rv = s.Push(x);
        cout << ((rv == 0) ?  "Insert failed\n" : "Insert succeeded\n");
        return 1;
     }
  cout << "Input operation failed" << endl;
  return 1;
}


int InsertBack(Queue<UString> &s)
{
  UString x;

  cout << "Enter new character string: ";
  cin >> x;
  if (cin) {
    int rv = s.Insert(x);
    cout << ((rv == 0) ?  "Insert failed\n" : "Insert succeeded\n");
    return 1;
  }

  cout << "Input operation failed" << endl;
  return 1;
}

template<class TYPE>
inline int Status(const Queue<TYPE> &s)
{
  if (s.IsEmpty()) cout << "Queue empty" << endl;
  else cout << "Queue is not empty" << endl;
  return 1;
}

int Quit()
{
  cout << "Exiting..." << endl;
  return 0;
}

void Menu(void)
{
  cout << "(C) Copy queue" << endl;
  cout << "(E) Extract front entry" << endl;
  cout << "(F) Show queue front" << endl;
  cout << "(H) Help" << endl;
  cout << "(i) Insert entry in back" << endl;
  cout << "(I) Insert entry in front" << endl;
  cout << "(S) Show queue status" << endl;
  cout << "(Q) Quit" << endl;
}

main()
{
  Queue<UString> a;

  int rv;
  char key;

  Menu();
  rv = 1;
  while(rv) {
    if (!cin) { // Input is in fail state
       SkipToEol(cin); // Go to end of line
       if (!cin) {  // Can't fix
          cout << "Input stream is broken" << endl;
          return 0;
       }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; // Fix at top of loop
    switch(key) {
      case 'i' : rv = InsertBack(a); break;
      case 'I' : rv = InsertFront(a); break;
      case 'c' : case 'C' : rv = Copy(a); break;
      case 'e' : case 'E' : rv = Extract(a); break;
      case 'f' : case 'F' : rv = Front(a); break;
      case 'h' : case 'H' : Menu(); break;
      case 's' : case 'S' : rv = Status(a); break;
      case 'q' : case 'Q' : rv = Quit(); break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

