// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: bnodeb.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Standalone functions that operate on BNodeBase pointers. This
implementation is used to provide maximum code sharing. 
*/
// ----------------------------------------------------------- // 
#include "bnodeb.hpp"
#include "queue.hpp"  // List based stack queue

int NumNodes(BNodeBase *Tree)
// Counts the number of nodes in a tree, using pre-order.
{
  int n = 0;
  if (Tree != 0) {
     ++n;
     while(Tree) {
       if (Tree->Left) n += NumNodes(Tree->Left);
       if (Tree->Right) {
          ++n; 
          Tree = Tree->Right;
       }
     }
  }
  return n;
}

int Height(BNodeBase *Tree)
// Determines the height of a tree. The height of a tree
// is the maximum height of its two sub-trees.
{
  int h = 0;
  if (Tree != 0) {
     int lh = Height(Tree->Left);
     int rh = Height(Tree->Right);
     h = ((lh > rh) ? lh : rh) + 1;
  }
  return h;
}

void PreOrder(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of the tree in pre-order (first the
// parent, then the left sub-tree, then the right sub-tree.)
// Tail recursion removed.
{
  while(Tree) {
    Visit(Tree);
    PreOrder(Tree->Left, Visit);
    Tree = Tree->Right;
  }
}

void InOrder(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree using in-order traversal, (first the Left
// sub-tree, then the parent, then the Right sub-tree.)
// Tail recursion removed
{
  while(Tree) {
    InOrder(Tree->Left, Visit);
    Visit(Tree);
    Tree = Tree->Right;
  }
}

void PostOrder(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree using post-order traversal (first the
// left sub-tree, then the right sub-tree, then the parent.)
{
  if (Tree == 0) return;
  PostOrder(Tree->Left, Visit);
  PostOrder(Tree->Right, Visit);
  Visit(Tree);
}

void PreOrderFlat(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree using pre-order traversal (first the
// parent, then the left sub-tree, then the right sub-tree),
// using an explicit stack.
{
  Stack<BNodeBase *> path; // Current path of parents through the tree

  while(1) {
    if (Tree) {
       Visit(Tree);
       path.Push(Tree);
       Tree = Tree->Left;
    }
    else {
      if (path.Pop(Tree) == 0) break;
      Tree = Tree->Right;
    }
  }
}

void InOrderFlat(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree using in-order traversal, (first the left
// sub-tree, then the parent, then the right sub-tree), using
// an explicit stack.
{
  Stack<BNodeBase *> path; // Current path of parents through the tree

  while(1) {
    if (Tree) {
       path.Push(Tree);
       Tree = Tree->Left;
    }
    else {
      if (path.Pop(Tree) == 0) break;
      Visit(Tree);
      Tree = Tree->Right;
    }
  }
}

void PostOrderFlat(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree using post order traversal (first the
// Left sub-tree, then the Right sub-tree, then the parent),
// using an explicit stack.
{
  Stack<BNodeBase *> path; // Current path of parents through the tree
  int state = 0;

  while(1) {
    if (state == 0) { // Ready to go down to the Left
       if (Tree) {
          path.Push(Tree);
          Tree = Tree->Left;
       }
       else state = 1;
    }
    else { // state == 1: Ready to come up from either direction
       BNodeBase *c = Tree;
       if (path.IsEmpty()) break;
       Tree = *path.Top();
        if (c == Tree->Left && Tree->Right) {
          // Coming back up the tree from the Left, and
          // there is a Right child, so go Right.
          // Note that Tree is still on top of stack.
          Tree = Tree->Right;
          state = 0;
       }
       else {
          // Coming back up the tree from the Right,
          // or there was no Right child, so visit
          // the node, and continue on up. (State
          // stays at 1.)
          Visit(Tree);
          path.Pop();
       }
    }
  }
}

void LvlOrder(BNodeBase *Tree, VisitFunc Visit)
// Visit each node of a tree left to right, level by level.
{
  Queue<BNodeBase *> path; // Current path of parents through the tree

  path.Insert(Tree);

  while(1) {
    BNodeBase *ptr;
    if (path.Extract(ptr) == 0) break;
    Visit(ptr);
    if (ptr->Left != 0) path.Insert(ptr->Left);
    if (ptr->Right != 0) path.Insert(ptr->Right);
  }
}

BNodeBase *RotateRight(BNodeBase *ptr)
// Rotates to the right about non-null ptr. Returns a
// pointer to the node that takes the place of ptr.
// Assumes the left child of ptr exists.
{
  BNodeBase *Tree = ptr->Left;
  ptr->Left = Tree->Right;
  Tree->Right = ptr;
  return Tree;
}

BNodeBase *RotateLeft(BNodeBase *ptr)
// Rotates to the left about non-null ptr. Returns a
// pointer to the node that takes the place of ptr.
// Assumes the right child of ptr exists.
{
  BNodeBase *Tree = ptr->Right;
  ptr->Right = Tree->Left;
  Tree->Left = ptr;
  return Tree;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
