// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: bnodeb.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Base class for binary tree nodes. The BNodeBase class is used to
separate the nodes from the data stored in the tree. Functions
that take BNodeBase pointers as parameters can be shared across
all Binary Trees regardless of the data type stored in the Tree
Nodes.
*/
// ----------------------------------------------------------- //   
#ifndef __BNODEB_HPP
#define __BNODEB_HPP

// An abstract binary tree node that holds no data.
class BNodeBase
{
public:
  BNodeBase *Left;
  BNodeBase *Right;
};

// VisitFunc is a pointer to void(BNodeBase *Node) which
// points to a function used for the visit action
typedef void (*VisitFunc)(BNodeBase *Node); 

// Standalone functions that operate on BNodeBase pointers.
// This implementation provides maximum code sharing.
BNodeBase *RotateRight(BNodeBase *Tree);
BNodeBase *RotateLeft(BNodeBase *Tree);
int NumNodes(BNodeBase *Tree);
int Height(BNodeBase *Tree);
void PreOrder(BNodeBase *Tree, VisitFunc Visit);
void InOrder(BNodeBase *Tree, VisitFunc Visit);
void PostOrder(BNodeBase *Tree, VisitFunc Visit);
void LvlOrder(BNodeBase *Tree, VisitFunc Visit);
void PreOrderFlat(BNodeBase *Tree, VisitFunc Visit);
void InOrderFlat(BNodeBase *Tree, VisitFunc Visit);
void PostOrderFlat(BNodeBase *Tree, VisitFunc Visit);

#endif // __BNODEB_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
