// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: rbnode.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

(R)ed (B)lack (B)inary (T)ree node classes. The RBNodeBase
class is derived from the BNodeBase class. The generic RBNode
class is then derived from the RBNodeBase class.
*/
// ----------------------------------------------------------- //   
#ifndef __RBNODE_HPP
#define __RBNODE_HPP

#include "bnodeb.hpp"

#define RedNode 0
#define BlackNode 1

// (R)ed (B)lack (N)ode (B)ase class
class RBNodeBase : public BNodeBase
{
public:
  RBNodeBase *GetLeft() { return (RBNodeBase *)Left; }
  RBNodeBase *GetRight() { return (RBNodeBase *)Right; }

public:
  char color; // Color of the link coming into the node
};

// (R)ed (B)lack (N)ode class
template<class TYPE>
class RBNode : public RBNodeBase
{
public:
  RBNode() { Left = 0; Right = 0; color = BlackNode; }

  RBNode // RBNode copy constructor
  (const TYPE &X, char c=1, RBNode<TYPE> *l=0, RBNode<TYPE> *r=0) : Data(X)
  {
    Left = l; Right = r; color = c;
  }

public:
  RBNode<TYPE> *GetLeft() { return (RBNode<TYPE> *)Left; }
  RBNode<TYPE> *GetRight() { return (RBNode<TYPE> *)Right; }

public:
  TYPE Data;
};

#endif // __RBNODE_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

