// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: treeprt.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Tree printing functions used to debug the code that works with
(R)ed (B)lack binary search trees.   
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "treeprt.hpp"
#include "twalk.hpp"

BNodeXY *GetNodePosn(BNodeBase *Tree, int &x, int y, NodeWidthFunc NodeWidth)
// Using an in-order traversal, figure out x and y of each node
// in the tree Tree, assuming that the top Left hand corner of the
// box bounding Tree is at (x, y). Builds a parallel shadow tree
// of nodes having x & y in them.
{
  if (Tree == 0) return 0;
  BNodeXY *l = GetNodePosn(Tree->Left, x, y+1, NodeWidth);
  BNodeXY *xyt = new BNodeXY;
  xyt->Left = l;
  xyt->x = x;
  x += NodeWidth(Tree);
  xyt->y = y;
  y++;
  xyt->Right = GetNodePosn(Tree->Right, x, y, NodeWidth);
  return xyt;
}

void PrintUp(BNodeBase *Tree, PrtFunc PrtNode, NodeWidthFunc NodeWidth)
// Print tree Tree upright, using positions in xyt as a guide
{
  int spacing, last_sp, x, oldy;
  BNodeBase *nxt;
  BNodeXY *xynxt;

  if (Tree == 0) { cout << "Empty tree\n"; return; }

  x = 1;
  BNodeXY *xyt = GetNodePosn(Tree, x, 0, NodeWidth);

  TreeWalkerb tw(Tree, LVLORDER);
  TreeWalker<BNodeXY> xytw(xyt, LVLORDER);

  oldy = 0;
  last_sp = 0;
  while(1) {
    xynxt = xytw.Next();
    if (xynxt == 0) break;
    if (xynxt->y != oldy) {
       oldy = xynxt->y;
       cout << '\n';
       last_sp = 0;
    }
    spacing = xynxt->x - last_sp - 1;
    if (spacing < 0) spacing = 0;
    while(spacing--) cout << ' ';
    nxt = tw.Next();
    PrtNode(nxt);
    last_sp = xynxt->x + NodeWidth(nxt) - 1;
  }
  cout << "\n\n";

  // Need to delete shadow tree. Easy to do with postorder traversal
  xytw.Reset(xyt, POSTORDER);
  while(1) {
    xynxt = xytw.Next();
    if (xynxt == 0) break;
    delete xynxt;
  }
}

void PrintSideWays(BNodeBase *Tree, PrtFunc PrtNode, int inc, int space)
// Using a right-to-Left in-order traversal
{
  while(Tree) {
    PrintSideWays(Tree->Right, PrtNode, inc, space+inc);
    for(int i = 0; i<space; i++) cout << ' ';
    PrtNode(Tree); cout << '\n';
    Tree = Tree->Left;
    space += inc;
  }
}

void TestTraversals(BNodeBase *root, VisitFunc Visit)
// Test every traversal method
{
  BNodeBase *nxt;

  if (root == 0) { cout << "Tree is empty\n"; return; }

  cout << "RecPre:   "; PreOrder(root, Visit); cout << '\n';
  cout << "FlatPre:  "; PreOrderFlat(root, Visit); cout << '\n';
  cout << "IterPre:  ";
  TreeWalkerb tw(root, PREORDER);
  while((nxt = tw.Next()) != 0) Visit(nxt);
  cout << '\n';

  cout << "RecIn:    "; InOrder(root, Visit); cout << '\n';
  cout << "FlatIn:   "; InOrderFlat(root, Visit); cout << '\n';
  cout << "IterIn:   ";
  tw.Reset(root, INORDER);
  while((nxt = tw.Next()) != 0) Visit(nxt);
  cout << '\n';

  cout << "RecPost:  "; PostOrder(root, Visit); cout << '\n';
  cout << "FlatPost: "; PostOrderFlat(root, Visit); cout << '\n';
  cout << "IterPost: ";
  tw.Reset(root, POSTORDER);
  while((nxt = tw.Next()) != 0) Visit(nxt);
  cout << '\n';

  cout << "FlatLvl:  "; LvlOrder(root, Visit);  cout << '\n';
  cout << "IterLvl:  ";
  tw.Reset(root, LVLORDER);
  while((nxt = tw.Next()) != 0) Visit(nxt);
  cout << '\n';
}

void TestTraversalsII(BNodeBase *root, VisitFunc Visit)
// Shorthand version
{
  if (root == 0) { cout << "Tree is empty\n"; return; }

  cout << "FlatPre:  "; PreOrderFlat(root, Visit); cout << '\n';
  cout << "FlatIn:   "; InOrderFlat(root, Visit); cout << '\n';
  cout << "FlatPost: "; PostOrderFlat(root, Visit); cout << '\n';
  cout << "FlatLvl:  "; LvlOrder(root, Visit);  cout << '\n';
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
