// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: twalk.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The TreeWalkerb class defines a generic iterator used to walk
through (R)ed (B)lack binary search trees. All of the member
functions are accessed via pointers to the member functions.
*/
// ----------------------------------------------------------- // 
#include "twalk.hpp"

void TreeWalkerb::Reset(BNodeBase *r, WalkOrder w)
{
  root = r;
  worder = w;
  if (worder == PREORDER) NextFptr = &TreeWalkerb::NextPreOrder;
  else if (worder == INORDER) NextFptr = &TreeWalkerb::NextInOrder;
  else if (worder == POSTORDER) NextFptr = &TreeWalkerb::NextPostOrder;
  else NextFptr = &TreeWalkerb::NextLvlOrder;
  state = 0;
  curr = root;
  path.Clear();
  if (root && worder == LVLORDER) path.Insert(root);
}

BNodeBase *TreeWalkerb::NextPreOrder()
{
  while(1) {
    if (curr) {
       path.Push(curr);
       BNodeBase *p = curr;
       curr = curr->Left;
       return p;
    }
    else {
      if (path.Pop(curr) == 0) {
         return curr = 0;
      }
      else curr = curr->Right;
    }
  }
}

BNodeBase *TreeWalkerb::NextInOrder()
{
  while(1) {
    if (curr) {
       path.Push(curr);
       curr = curr->Left;
    }
    else {
      if (path.Pop(curr) == 0) {
         return curr = 0;
      }
      else {
         BNodeBase *p = curr;
         curr = curr->Right;
         return p;
      }
    }
  }
}

BNodeBase *TreeWalkerb::NextPostOrder()
{
  while(1) {
    if (state == 0) { // Ready to go down the tree to left
       if (curr) {
         path.Push(curr);
          curr = curr->Left;
       }
       else state = 1;
    }
    else { // State == 1: // Ready to come up the tree
       BNodeBase *c = curr;
       if (path.IsEmpty()) return curr = 0; // At root
       curr = *path.Top();
       if (c == curr->Left && curr->Right) {
          // Coming back up the tree from the left, and
          // there is a right child, so go right. 
          // Note that curr is still on top of stack.
          curr = curr->Right;
          state = 0;
       }
       else {
          // Coming back up the tree from the right,
          // or there was no right child, so visit
          // the node, and continue on up. (State
          // stays at 1.)
          path.Pop();
          return curr;
       }
    }
  }
}

BNodeBase *TreeWalkerb::NextLvlOrder()
{
  if (path.Extract(curr) == 0) return 0;
  if (curr->Left != 0)  path.Insert(curr->Left);
  if (curr->Right != 0) path.Insert(curr->Right);
  return curr;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
