// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: twalk.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 01/23/1997 
// Date Last Modified: 07/28/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The TreeWalkerb class defines a generic iterator used to walk
through (R)ed (B)lack binary search trees. All of the member
functions are accessed via pointers to the member functions.
*/
// ----------------------------------------------------------- //   
#ifndef __TWALK_HPP
#define __TWALK_HPP

#include "queue.hpp"   // List based stack queue
#include "rbnode.hpp"  // Red Black tree node
#include "bnode.hpp"   // Binary tree node

enum WalkOrder {
  PREORDER,  // Visit Root first, then Left, then Right subtree recursively  
  POSTORDER, // Visit Left subtree first, then Right, then Root recursively
  INORDER,   // Visit Left subtree first, then Root, then Right recursively
  LVLORDER   // Visit (L)evel by (L)evel, start at Root, and go Left to Right
};

// (T)ree (W)alker (B)ase class
class TreeWalkerb  
{
public:
  TreeWalkerb(BNodeBase *r, WalkOrder w) { Reset(r, w); }
  virtual ~TreeWalkerb() { }

public:
  void Reset() { Reset(root, worder); }
  void Reset(BNodeBase *r, WalkOrder w);
  BNodeBase *Next() { return (this->*NextFptr)(); }

protected:
  BNodeBase *(TreeWalkerb::* NextFptr)(); // Pointer to member functions
  BNodeBase *NextPreOrder();
  BNodeBase *NextInOrder();
  BNodeBase *NextPostOrder();
  BNodeBase *NextLvlOrder();

protected:
  Queue<BNodeBase *> path; // Current path of parents through the tree
  BNodeBase *root;  // Start of the tree being iterated
  BNodeBase *curr;  // Current node being traversed
  int state;        // Holds up or down state indication for POSTORDER
  WalkOrder worder; // Enumerated type of WalkOrder 
};

template<class NTYPE>
class TreeWalker : private TreeWalkerb
{
public:
  TreeWalker(NTYPE *r, WalkOrder w) : TreeWalkerb(r, w) { }
  
public:
  void Reset() { TreeWalkerb::Reset(); }
  void Reset(NTYPE *r, WalkOrder w) { TreeWalkerb::Reset(r, w); }
  NTYPE *Next() { return (NTYPE *)((this->*NextFptr)()); }
};

#endif // __TWALK_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
