#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/09/1997 
# Date Last Modified: 01/17/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
QUEUE_PATH = ../../queue/base/
SLLISTB_PATH = ../../sllist/base/
STACK_PATH = ../../stack/base/
USTRING_PATH = ../../ustring/base/

ADD_INC_PATHS = /I../base /I../../queue/base /I../../sllist/base \
/I../../stack/base /I../../ustring/base

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /W3 $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
BNODEB_DEP = $(BASE_PATH)bnodeb.hpp $(QUEUE_PATH)queue.hpp \
	$(SLLISTB_PATH)sllist.hpp $(SLLISTB_PATH)sllistb.hpp \
	$(STACK_PATH)stack.hpp

BSTREEB_DEP = $(BASE_PATH)bnode.hpp $(BASE_PATH)bnodeb.hpp \
	$(BASE_PATH)bstreeb.hpp

RBTREEB_DEP = $(BASE_PATH)bnode.hpp $(BASE_PATH)bnodeb.hpp \
	$(BASE_PATH)bstreeb.hpp $(QUEUE_PATH)queue.hpp \
	$(BASE_PATH)rbnode.hpp $(BASE_PATH)rbtree.hpp \
	$(BASE_PATH)rbtreeb.hpp $(SLLISTB_PATH)sllist.hpp \
	$(SLLISTB_PATH)sllistb.hpp $(STACK_PATH)stack.hpp \
	$(BASE_PATH)twalk.hpp

SLLISTB_DEP = $(SLLISTB_PATH)sllistb.hpp

TESTPROG_DEP = $(BASE_PATH)bnode.hpp $(BASE_PATH)bnodeb.hpp \
	$(BASE_PATH)bstreeb.hpp $(QUEUE_PATH)queue.hpp \
	$(BASE_PATH)rbnode.hpp $(BASE_PATH)rbtree.hpp \
	$(BASE_PATH)rbtreeb.hpp $(SLLISTB_PATH)sllist.hpp \
	$(SLLISTB_PATH)sllistb.hpp $(STACK_PATH)stack.hpp \
	$(BASE_PATH)treeprt.hpp $(BASE_PATH)twalk.hpp \
	$(USTRING_PATH)ustring.hpp

TREEPRT_DEP = $(BASE_PATH)bnode.hpp $(BASE_PATH)bnodeb.hpp \
	$(QUEUE_PATH)queue.hpp $(BASE_PATH)rbnode.hpp \
	$(SLLISTB_PATH)sllist.hpp $(SLLISTB_PATH)sllistb.hpp \
	$(STACK_PATH)stack.hpp $(BASE_PATH)treeprt.hpp \
	$(BASE_PATH)twalk.hpp

TWALK_DEP = $(BASE_PATH)bnode.hpp $(BASE_PATH)bnodeb.hpp \
	$(QUEUE_PATH)queue.hpp $(BASE_PATH)rbnode.hpp \
	$(SLLISTB_PATH)sllist.hpp $(SLLISTB_PATH)sllistb.hpp \
	$(STACK_PATH)stack.hpp $(BASE_PATH)twalk.hpp

USTRING_DEP = $(USTRING_PATH)ustring.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

bnodeb.obj:	$(BASE_PATH)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)bnodeb.cpp

bstreeb.obj:	$(BASE_PATH)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)bstreeb.cpp

rbtreeb.obj:	$(BASE_PATH)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)rbtreeb.cpp

sllistb.obj:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

treeprt.obj:	$(BASE_PATH)treeprt.cpp $(TREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)treeprt.cpp

twalk.obj:	$(BASE_PATH)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)twalk.cpp

ustring.obj:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = bnodeb.obj bstreeb.obj rbtreeb.obj sllistb.obj testprog.obj \
	treeprt.obj twalk.obj ustring.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


