// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 02/03/97 
// Date Last Modified: 12/03/97
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the RefCount class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "refcount.hpp"

class String :  public CountedObject
{ 
public:
  String() { str = 0; }
  String(char *s) { Store(s); }
  String(int sz);
  ~String() { delete str; }    
  String(const String &s) { Store(s.str); }

  String &operator=(const String &s) {
    if(this != &s) {
      str = 0;
      Store(s.str);
    }
    return *this;
  }

public:
  void Store(char *s);
  char *c_str() const { return str; } 

public:
  friend int operator==(const String &a, const String &b) {
    return strcmp(a.str, b.str) == 0;
  }

  friend int operator<(const String &a, const String &b) {
    return strcmp(a.str, b.str) < 0;
  }

  friend int operator>(const String &a, const String &b) {
    return strcmp(a.str, b.str) > 0;
  }

  friend int operator!=(const String &a, const String &b) {
    return strcmp(a.str, b.str) != 0;
  }
  
  friend ostream &operator<<(ostream &os, const String &s) {
    return os.write(s.str, strlen(s.str));
  }

  friend istream &operator>>(istream &os, String &s) {
    os >> setw(strlen(s.str)) >> s.str;
    return os;
  }
	       
private:
  char *str;
};

String::String(int sz)
{
  str = new char[sz+1];
  str[sz] = '\0';
}

void String::Store(char *s)
{
  size_t len = strlen(s);
  str = new char[len+1];
  str[len] = '\0';
  strcpy(str, s);
}

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

typedef RefCount<String> StringPtr;

int main()
{
  cout << "Dnamically creating String object pointers on the heap..." << endl;
  StringPtr s1(new String);
  StringPtr s2(new String);
  
  cout << "Object pointer s1 reference count = " << s1->Count() << endl;
  cout << "Object pointer s2 reference count = " << s2->Count() << endl;
  
  // Call to overloaded ! operator in RefCount class
  if(!s1) cout << "Cannot allocate memory" << endl;
  
  // Call to overloaded -> operator in RefCount class
  s1->Store("This is String object's data");

  // Call to overloaded * operator in RefCount class
  cout << *s1 << endl; 
  
  pause();

  cout << "Assigning reference counted objects pointers s2 = s1..." << endl;
  s2 = s1;
  cout << *s2 << endl;
  cout << "Object s1 reference count = " << s1->Count() << endl;
  cout << "Object s2 reference count = " << s2->Count() << endl;

  pause();
  
  cout << "Copying reference counted objects pointers s3(s1)..." << endl;
  StringPtr s3(s1);
  cout << *s3 << endl;
  cout << "Object pointer s1 reference count = " << s1->Count() << endl;
  cout << "Object pointer s2 reference count = " << s2->Count() << endl;
  cout << "Object pointer s3 reference count = " << s3->Count() << endl;
  
  pause();
  
  cout << "Testing overloaded * operator in RefCount class..." << endl;
  cout << "Creating String object str..." << endl;
  String str = *s1;
  cout << str << endl;

  pause();
  
  cout << "Releasing object poiner s1 reference count..." << endl;
  s1->Release();
  cout << "Object pointer s1 reference count = " << s1->Count() << endl;
  cout << "Object pointer s2 reference count = " << s2->Count() << endl;
  cout << "Object pointer s3 reference count = " << s3->Count() << endl;
  
  cout << endl;
  cout << "Automatic destructor call to destroy object str..." << endl;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
