#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: HP C++ A.10.24 compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 01/19/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
#
# To get the current compiler version number enter the 
# following command:
# 
# 	% what /opt/CC/bin/CC
#
# NOTE: Edit the unix.env path to change the path setting
# for the wxWindows GUI library installation path
# ---------------------------------------------------------------

# Set the wxWindows GUI library installation path marco
include ../../../env/wx_unix.env

# All common UNIX compiler flags and options are now in
# this central makefile.
include $(WXDIR)/src/make.env

# Setup additional paths for includes and source code
BASE_PATH = ../base/

ADD_INC_PATHS = -I../base

# Setup define macros
DEFMACS = 

# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld   # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= $(CPPFLAGS) $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LINK_FLAGS = $(LDFLAGS) 
LINK_LIBS = $(MOTIFLDLIBS)


# Build dependency rules
# ===============================================================
TESTPROG_DEP = $(BASE_PATH)refcount.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

# Make the executable
OBJS = testprog.o

$(PROJECT):	$(OBJS) $(WXLIB)
	$(CPP) $(COMPILE_FLAGS) $(OBJS) $(OUTPUT) $(PROJECT) \
	$(LINK_FLAGS) $(LINK_LIBS) 

# ===============================================================
# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
