#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 01/19/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup wxWindows for MSVC 4.0
!include ..\..\..\env\wx_msvc.env
!include $(WXDIR)\src\ntwxwin.mak

# Setup additional paths for includes and source code
BASE_PATH = ../base/

ADD_INC_PATHS = /I../base

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
AC     = cl   # ANSI c compiler
CPP    = cl   # C++ compiler
LINKER = link # Linker

# Resource compiler for MSVC
RC = rc

# Compiler and linker flags 
COMPILE_FLAGS= $(CPPFLAGS) $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LINK_FLAGS = $(LINKFLAGS)
LINK_LIBS = $(LIBS)

# Build dependency rules
# ===============================================================
TESTPROG_DEP = $(BASE_PATH)refcount.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

testprog.res:	testprog.rc $(WXDIR)\include\msw\wx.rc
	$(RC) -r /i$(WXDIR)\include\msw /i$(WXDIR)\contrib\fafa -fo$@ \
	testprog.rc

# Make the executable
OBJECTS = testprog.obj 
RCS = testprog.res

$(PROJECT).exe:	$(DUMMYOBJ) $(OBJECTS) $(RCS) $(WXLIB)
	$(LINKER) $(LINK_FLAGS) $(DUMMYOBJ) $(OBJECTS) $(RCS) \
	$(LINK_LIBS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .RES files from working directory...
	if exist *.res del *.res 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


