// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: sllist.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/29/1996  
// Date Last Modified: 08/19/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a generic singly linked list class dervied from the
SNodeBase class and the SLListBase class.

Changes 
================================================================
08/19/1998 - Remove duplicate definition of overloaded
assignment operator.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- // 
#ifndef __SLLIST_HPP
#define __SLLIST_HPP

#include "sllistb.hpp"

// (S)ingly Linked List (N)ode class 
template<class TYPE>
class SNode: public SNodeBase
{
public:
  SNode() { } // Implicitly call default constructor for Data
  SNode(const TYPE &X) : Data(X) { } // Call copy constructor

public:
  SNode<TYPE> *GetNext() { return (SNode<TYPE> *)Next; }
  const SNode<TYPE> *GetNext() const { return (SNode<TYPE> *)Next; }

public:
  TYPE Data;
};

// (S)ingly (L)inked (L)ist class declaration
template<class TYPE>
class SLList : public SLListBase
{
public:
  SLList() { }
  virtual ~SLList();
  SLList(const SLList<TYPE> &X);
  void operator=(const SLList<TYPE> &X);

public:
  int Copy(const SLList<TYPE> &List);
  int Cat(const SLList<TYPE> &X) { return SLListBase::Cat(X); }
  const SNode<TYPE> *Find(const TYPE &X, const SNode<TYPE> *ptr=0) const;
  SNode<TYPE> *Find(const TYPE &X, SNode<TYPE> *ptr=0);
  int DeleteNext(SNode<TYPE> *Node, TYPE *X = 0);
  int DeleteFront(TYPE *X = 0);
  SNode<TYPE> *StoreNode(const TYPE &X);
  SNode<TYPE> *AddToFront(const TYPE &X);
  SNode<TYPE> *AddToBack(const TYPE &X);
  SNode<TYPE> *AddAfter(const TYPE &X, SNode<TYPE> *Node);
  SNode<TYPE> *GetHeader() { return(SNode<TYPE> *) this; }
  const SNode<TYPE> *GetHeader() const { return(SNode<TYPE> *) this; }
  SNode<TYPE> *GetFront() { return(SNode<TYPE> *)SLListBase::GetFront(); }
  SNode<TYPE> *GetBack() { return (SNode<TYPE> *)SLListBase::GetBack(); }
  
  const SNode<TYPE> *GetFront() const { // Read only version
    return(SNode<TYPE> *)SLListBase::GetFront();
  }

  const SNode<TYPE> *GetBack() const { // Read only version
    return (SNode<TYPE> *)SLListBase::GetBack();
  }

  int IsHeader(const SNode<TYPE> *Node) const {
    return SLListBase::IsHeader(Node);
  }
  TYPE *GetFrontNode() {
    SNode<TYPE> *ptr = (SNode<TYPE> *)SLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const TYPE *GetFrontNode() const {
    SNode<TYPE> *ptr = (SNode<TYPE> *)SLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  TYPE *GetBackNode() {
    SNode<TYPE> *ptr = (SNode<TYPE> *)SLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const TYPE *GetBackNode() const {
    SNode<TYPE> *ptr = (SNode<TYPE> *)SLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

public:
  void InsertAfter(SNode<TYPE> *A, SNode<TYPE> *B) {
    SLListBase::InsertAfter(A, B);
  }

  void AttachToFront(SNode<TYPE> *Node) {
    SLListBase::AttachToFront(Node);
  }

  void AttachToBack(SNode<TYPE> *Node) {
    SLListBase::AttachToBack(Node);
  }

  SNode<TYPE> *RmvFront() {
    return(SNode<TYPE> *)(SLListBase::RmvFront());
  }

  SNode<TYPE> *RmvNext(SNode<TYPE> *Node) {
    return(SNode<TYPE> *)(SLListBase::RmvNext(Node));
  }

protected:
  virtual SNode<TYPE> *AllocNode(const TYPE &X);
  virtual SNodeBase *DupNode(const SNodeBase *Node);
  virtual void FreeNode(SNodeBase *Node);
  
public: // Overloaded operators
  int operator+=(const SLList<TYPE> &X) { return Cat(X); }
};

template<class TYPE>
SLList<TYPE>::~SLList()
{
  Clear();
}

template<class TYPE>
SLList<TYPE>::SLList(const SLList<TYPE> &X)
{
  Copy(X);
}

template<class TYPE>
void SLList<TYPE>::operator=(const SLList<TYPE> &X)
{
  Copy(X);
}

template<class TYPE>
int SLList<TYPE>::Copy(const SLList<TYPE> &List)
{
  return SLListBase::Copy(List);
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::AllocNode(const TYPE &X)
{
  return new SNode<TYPE>(X); 
}

template<class TYPE>
SNodeBase *SLList<TYPE>::DupNode(const SNodeBase *Node)
{
  return AllocNode(((SNode<TYPE> *)Node)->Data);
}

template<class TYPE>
void SLList<TYPE>::FreeNode(SNodeBase *Node)
{
  delete((SNode<TYPE> *)Node);
}

template<class TYPE>
const SNode<TYPE> *SLList<TYPE>::
Find(const TYPE &X, const SNode<TYPE> *ptr) const
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(ptr->Data == X) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::Find(const TYPE &X, SNode<TYPE> *ptr)
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(ptr->Data == X) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

template<class TYPE>
int SLList<TYPE>::DeleteNext(SNode<TYPE> *Node, TYPE *X)
{
  SNode<TYPE> *ptr = RmvNext(Node);
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

template<class TYPE>
int SLList<TYPE>::DeleteFront(TYPE *X)
{
  SNode<TYPE> *ptr = RmvFront();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::StoreNode(const TYPE &X)
{
  SNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::AddToFront(const TYPE &X)
{
  SNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToFront(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::AddToBack(const TYPE &X)
{
  SNode<TYPE> *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

template<class TYPE>
SNode<TYPE> *SLList<TYPE>::AddAfter(const TYPE &X, SNode<TYPE> *Node)
{
  SNode<TYPE> *ptr = AllocNode(X);
  if(ptr) InsertAfter(Node, ptr);
  return ptr; // Return a pointer to the node added
}

#endif // __SLLIST_HPP
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
