// ----------------------------------------------------------- // 
// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: sllistb.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Base classes for singly linked list implementations. The
SNodeBase class and the SDLListBase class separates the
nodes from the data stored in the list by storing pointers
to the data. Classes derived from these base classes can
deal with any type of node data.
*/
// ----------------------------------------------------------- //   
#ifndef __SLLISTB_HPP
#define __SLLISTB_HPP

// (S)ingly Linked List (N)ode (B)ase class 
class SNodeBase
{
protected:
  friend class SLListBase;

protected:
  void InsertAfter(SNodeBase *Node);
  SNodeBase *RmvNext();
  void SelfRef() { Next = this; }

protected:
  SNodeBase *Next;
};

// (S)ingly (L)inked (L)ist (B)ase class 
class SLListBase : public SNodeBase
{
protected:
  SLListBase() { MakeEmpty(); }
  virtual ~SLListBase();

public:
  virtual void Clear();
  int IsEmpty() const { return (const SNodeBase *)Next == this; }
  int IsHeader(const SNodeBase *Node) const { return Node == this; }
protected:
  virtual SNodeBase *DupNode(const SNodeBase *Node) = 0;
  virtual void FreeNode(SNodeBase *Node) = 0;
  virtual void MakeEmpty();
  SNodeBase *GetHeader() { return this; }
  const SNodeBase *GetHeader() const { return this; }
  SNodeBase *GetFront() { return Next; }
  const SNodeBase *GetFront() const { return Next; }
  SNodeBase *GetBack() { return Back; }
  const SNodeBase *GetBack() const { return Back; }

  void InsertAfter(SNodeBase *A, SNodeBase *B) {
    A->InsertAfter(B);
    if(A == Back) Back = B;
  }

  void AttachToFront(SNodeBase *Node) { InsertAfter(this, Node); }
  void AttachToBack(SNodeBase *Node) { InsertAfter(Back, Node); }
  SNodeBase *RmvNext(SNodeBase *Node);
  SNodeBase *RmvFront() { return RmvNext(this); } // Does not delete node
  int Copy(const SLListBase &List);
  int Cat(const SLListBase &List);

protected:
  SNodeBase *Back;
};

#endif  // __SLLISTB_HPP //
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
