// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: strdb.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 10/29/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The StrDB class is a general purpose string database used to
represent one unique key member, 7 general purpose members,
and one comment block. All the string members can grow and
shrink as needed
*/
// ----------------------------------------------------------- //   
#ifndef __STRDB_HPP__
#define __STRDB_HPP__

#include "persist.hpp"
#include "dbvers.hpp"

const INT32 StrDBVersion = 1024; // String database class version number

typedef UString KeyMember; // Key alphanumeric data member 
typedef UString Member2;   // Second alphanumeric data member  
typedef UString Member3;   // Third alphanumeric data member 
typedef UString Member4;   // Fourth alphanumeric data member 
typedef UString Member5;   // Fifth alphanumeric data member 
typedef UString Member6;   // Sixth alphanumeric data member 
typedef UString Member7;   // Seventh alphanumeric data member 
typedef UString Member8;   // Eighth alphanumeric data member 
typedef UString Comment;   // Comment alphanumeric data member 

// String Database class
class StrDB : public Persistent
{
public:
  StrDB() { KM = M2 = M3 = M4 = M5 = M6 = M7 = M8 = CM = "\0"; }
  StrDB(const POD *pod) : Persistent(pod) {
    KM = M2 = M3 = M4 = M5 = M6 = M7 = M8 = CM = "\0"; 
  }
  StrDB(POD *pod) : Persistent(pod) {
    KM = M2 = M3 = M4 = M5 = M6 = M7 = M8 = CM = "\0"; 
  }
  StrDB(const StrDB &ob) { Copy(ob); }
  void operator=(const StrDB &ob) { Copy(ob); }
  
public: 
  void SetKM(const char *s) { KM = s; }
  void SetKM(const UString &s) { KM = s; }
  void SetM2(const char *s) { M2 = s; }
  void SetM2(const UString &s) { M2 = s; }
  void SetM3(const char *s) { M3 = s; }
  void SetM3(const UString &s) { M3 = s; }
  void SetM4(const char *s) { M4 = s; }
  void SetM4(const UString &s) { M4 = s; }
  void SetM5(const char *s) { M5 = s; }
  void SetM5(const UString &s) { M5 = s; }
  void SetM6(const char *s) { M6 = s; }
  void SetM6(const UString &s) { M6 = s; }
  void SetM7(const char *s) { M7 = s; }
  void SetM7(const UString &s) { M7 = s; }
  void SetM8(const char *s) { M8 = s; }
  void SetM8(const UString &s) { M8 = s; }
  void SetCM(const char *s) { CM = s; }
  void SetCM(const UString &s) { CM = s; }
  const char *GetKM() const { return KM.c_str(); }
  char *GetKM() { return KM.c_str(); }
  const char *GetM2() const { return M2.c_str(); }
  char *GetM2() { return M2.c_str(); }
  const char *GetM3() const { return M3.c_str(); }
  char *GetM3() { return M3.c_str(); }
  const char *GetM4() const { return M4.c_str(); }
  char *GetM4() { return M4.c_str(); }
  const char *GetM5() const { return M5.c_str(); }
  char *GetM5() { return M5.c_str(); }
  const char *GetM6() const { return M6.c_str(); }
  char *GetM6() { return M6.c_str(); }
  const char *GetM7() const { return M7.c_str(); }
  char *GetM7() { return M7.c_str(); }
  const char *GetM8() const { return M8.c_str(); }
  char *GetM8() { return M8.c_str(); }
  const char *GetCM() const { return CM.c_str(); }
  char *GetCM() { return CM.c_str(); }
  INT32 Version() { return StrDBVersion; }

public:
  void Copy(const StrDB &ob);
  int FullCompare(const StrDB &ob);

private: // Base class interface
  virtual FAU Write();
  virtual void Read(FAU Address);
  virtual FAU Find();
  virtual FAU Delete();
  virtual FAU Remove();

public: // Base class interface

  // 02/05/1998 Changed to public access
  virtual INT32 GetClassID() const { return SClassID; }

  // 02/05/1998 Changed to public access
  virtual const char *GetClassName() { return "Class StrDB"; }

  virtual unsigned ObjectLength();
  virtual void SetObjectAddress(FAU addr) { objectaddress = addr; }
  virtual FAU GetObjectAddress() { return objectaddress; }
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);

public: // Overloaded operators
  friend int operator==(const StrDB &a, const StrDB &b);
  friend int operator!=(const StrDB &a, const StrDB &b);
  friend int operator>(const StrDB &a, const StrDB &b);
  friend int operator>=(const StrDB &a, const StrDB &b);
  friend int operator<(const StrDB &a, const StrDB &b);
  friend int operator<=(const StrDB &a, const StrDB &b);
  
private:
  KeyMember KM;
  Member2 M2;
  Member3 M3;
  Member4 M4;
  Member5 M5;
  Member6 M6;
  Member7 M7;
  Member8 M8;
  Comment CM;
};

#endif  // __STRDB_HPP__ 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
