// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: strdb_sh.cpp 
// C++ Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 10/09/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the string database.
*/
// ----------------------------------------------------------- //
#include "strdb_sh.hpp"

// Global data structures used to organize and store btree nodes
DLList<InMemCopy> StrDB_SH_DLList;            // Doubly Linked
DLList<InMemCopy> *dllist = &StrDB_SH_DLList; // Doubly Linked
DNode<InMemCopy> *dllistptr = 0;              // DLList node pointer
RBTree<InMemCopy> StrDB_SH_RBTree;            // Red Black tree
RBTree<InMemCopy> *rbtree = &StrDB_SH_RBTree; // Red Black tree

// Variable used to count the number of object found during a search
int ObjectsFound = 0;

void LoadKeys(CachePointer n)
// Visit function used to load the btree nodes into memory
{
  int i = 0;

  while (i < n->cnt) {
    InMemCopy buf(n->entry[i].key,
		  n->entry[i].object_address,
		  n->entry[i].class_id);

    rbtree->Add(buf);
    i++;
  }
}

void BtreeSearch(CachePointer t, SearchVisitFunc Visit, int item,
		 StrDB &strdb, UString &str, int find_all) 
// Recursive functions used to search the btree for a specified.
{
  int i;

  if ((__LWORD__)t) {
    (*Visit)(t, item, strdb, str, find_all); // Process the node data
    int n = t->cnt;
    CachePointer p(t);

    for(i = -1; i < n; i++) {
      p = t->Branch(i);
      t.Release();
        BtreeSearch(p, Visit, item, strdb, str, find_all);  
    }
  }
}

void BtreeNodeSearch(CachePointer n, int item, StrDB &strdb, UString &str,
		     int find_all)
// Visit function used to search each node for a specified item
{
  int i = 0;
  int offset;
  UString buf;

  if(item == KEYMEMBER) {
    while (i < n->cnt) {
      buf = n->entry[i].key;
      if(find_all == 0) { // Search for single match
	int result = CaseICmp(buf, str);
	if(result == 0) { 
	  InMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      else { // Search for all matches
	offset = buf.Find(str.c_str(), 0);
	if(offset != UString::NoMatch) {
	  InMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      i++;
    }
  }
  else {
    while (i < n->cnt) {
      strdb.ReadObject(n->entry[i].object_address);
      switch(item) {
	case M2NAME:
	  buf = strdb.GetM2();
	  break;
	case M3NAME:
	  buf = strdb.GetM3();
	  break;
	case M4NAME:
	  buf = strdb.GetM4();
	  break;
	case M5NAME:
	  buf = strdb.GetM5();
	  break;
	case M6NAME:
	  buf = strdb.GetM6();
	  break;
	case M7NAME:
	  buf = strdb.GetM7();
	  break;
	case M8NAME:
	  buf = strdb.GetM8();
	  break;
	case COMMENTS:
	  buf = strdb.GetCM();
	  break;
	default:
	  return;
      }
      if(find_all == 0) { // Search for single match
	int result = CaseICmp(buf, str);
	if(result == 0) { 
	  InMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      else { // Search for all matches
	offset = buf.Find(str.c_str(), 0);
	if(offset != UString::NoMatch) {
	  InMemCopy inmemcopy(n->entry[i].key,
			      n->entry[i].object_address,
			      n->entry[i].class_id);
	  rbtree->Add(inmemcopy);
	  ObjectsFound++;
	}
      }
      i++;
    }
  }
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

