// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: strutil.cpp 
// C++ Compiler Used: MSVC40 
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General string utility functions use to manipulate and parse
null-terminated character strings.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "strutil.hpp"

// This include file is no longer used
// #include "os_type.hpp"

// Enable this macro DOS and Windows applications
// #ifndef __DOS__
// #define __DOS__
// #endif 

// Enable this macro for Generic Unix applications
// #ifndef __UNIX__
// #define __UNIX__
// #endif 

char *StringCat(const char *s1, const char *s2, const char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

char *StringCat(char *s1, char *s2, char *s3)
{
  int len = strlen(s1) + strlen(s2) + strlen(s3);
  char *comp = new char[len];
  comp[len] = '\0';
  strcpy(comp, s1);
  strcat(comp, s2);
  strcat(comp, s3);
  return comp;
}

int parse(char *string, char words[MAXWORDS][MAXWORDLENGTH],
	  int*numwords, char sepchar)
// General purpose string parser
{
  int i = 0;
  char newword[MAXWORDLENGTH];
  *numwords = 0;

  // First skip over leading blanks. Stop if an ASCII NULL is seen
  while (1) {
    if (*string == '\0') return 0;
    if (*string != ' ') break;
    string++;
  }
  
  while(1) {
    // Check to see if there is room for another word in the array
    if(*numwords == MAXWORDS) return 1;

    i = 0;
    while (i < MAXWORDLENGTH) {
      if(*string == 0 || *string == sepchar) break;
      newword[i] = *string;
      string++;
      i++;
    }
    newword[i] = 0;   // Ensure an ASCII null at end of newword. 
    strcpy (words[*numwords], newword);  // Install into array 
    (*numwords)++;
    
    // If stopped by an ASCII NULL above, exit loop
    if(*string == 0) break;
    
    string++;
    if(*string == 0) break;
  }
  return 0;
}

int CaseICmp(const char *s1, const char *s2)
// Compare two strings without regard to the case of the letters
{
#ifdef __DOS__
  return stricmp(s1, s2);
#endif

#ifdef __UNIX__
  return strcasecmp(s1, s2);
#endif
}

int CaseICmp(char *s1, char *s2)
// Compare two strings without regard to the case of the letters
{
#ifdef __DOS__
  return stricmp(s1, s2);
#endif

#ifdef __UNIX__
  return strcasecmp(s1, s2);
#endif
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
