// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: terminal.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 03/21/1997 
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a terminal interface designed to be portable between
DOS and UNIX systems. On UNIX systems the "curses" library is
used to create terminal independent code. On MSDOS/Windows95
systems the ANSI.SYS driver is used to simulate the basic
functions of the "curses" library.
*/
// ----------------------------------------------------------- //   
#ifndef __TERMINAL_HPP
#define __TERMINAL_HPP

#include <stdio.h>
#include <stdlib.h>

// This include file is no longer used
// #include "os_type.hpp" 

// Set this macro DOS and Windows applications
// #ifndef __DOS__
// #define __DOS__
// #endif 

// Set this macro Generic Unix applications
// #ifndef __UNIX__
// #define __UNIX__
// #endif 

#ifdef __UNIX__
#include <curses.h> // Terminal independent I/O library
#endif

#ifdef __DOS__
#include <conio.h> // Console I/O library
#endif

// Key definitions
const int Escape = 27;
#define CONTROL(c) ((c) & 037) 

// Screen (C)oordinates class
class Coords
{
public:
  Coords() { xpos = ypos = 0; }
  Coords(int x, int y) { xpos = x; ypos = y; }
  ~Coords() { }
  Coords(const Coords &ob) { xpos = ob.xpos ; ypos = ob.ypos; }
  Coords &operator=(const Coords &ob) {
    xpos = ob.xpos ; ypos = ob.ypos; return *this;
  } 
  
public:
  int XPos() { return xpos; } // Current x coordinate
  int YPos() { return ypos; } // Current y coordinate 
  int XNext() { int x = xpos + 1; return x; } 
  int YNext() { int y = ypos + 1; return y; }
  int XPrev() { int x = xpos - 1; return x; }
  int YPrev() { int y = ypos - 1; return y; }
  int XOffset(int x) { xpos = xpos + x; return xpos; } 
  int YOffset(int y) { ypos = ypos + y; return ypos; }
  void SetXY(int x, int y) { xpos = x; ypos = y; }
  void SetX(int x) { xpos = x; }
  void SetY(int y) { ypos = y; }

private:
  int xpos;
  int ypos;
};

// ANSI (T)erminal class
class Terminal
{
public:
  Terminal() { putback = 0; }
  ~Terminal() { }

public: // Standard dialogs
  int YesNo(int x = -1, int y = -1);
  int YesNo(const char *s, int x = -1, int y = -1);
  int GetYesNo();
  void AnyKey(int x = -1, int y = -1);
  void AnyKey(const char *s, int x = -1, int y = -1);
  
public: // Terminal setup and screen operations
  void init();
  void finish();
  char *GetTerm() { return getenv("TERM"); }
  int MaxLines() { return maxlines; } 
  int MaxLines() const { return maxlines; }
  int MaxCols() { return maxcols; }
  int MaxCols() const { return maxcols; }
  void SetMaxLines(int lines);
  void SetMaxCols(int cols);
  void MoveCursor(int x, int y) const;
  void MoveCursor(int x, int y);
  void ClearScreen() const;
  void ClearScreen();
  void ClearLine(int x = -1, int y = -1) const;
  void ClearLine(int x = -1, int y = -1);
  int Center(const char *s) const; // Return center coordinate for a string
  int Center(char *s);
  int Right(const char *s) const;  // Return right justifed coordinate
  int Right(char *s);  
  int ScreenCenter(const int offset) const; // Return screen's center
  int ScreenCenter(int offset); 
  
public: // Output functions
  void Write(const char c, int x = -1, int y = -1) const;
  void Write(char c, int x = -1, int y = -1);
  void Write(const unsigned char c, int x = -1, int y = -1) const;
  void Write(unsigned char c, int x = -1, int y = -1);
  void Write(const char *s, int x = -1, int y = -1) const;
  void Write(char *s, int x = -1, int y = -1);
  void Write(const long val, int x = -1, int y = -1) const;
  void Write(long val, int x = -1, int y = -1);
  void Write(const int val, int x = -1, int y = -1) const;
  void Write(int val, int x = -1, int y = -1);
  void Write(double val, int x = -1, int y = -1); 
  void Write(const double val, int x = -1, int y = -1) const; 
  void Write(float val, int x = -1, int y = -1); 
  void Write(const float val, int x = -1, int y = -1) const; 
  void StatusLine(const char *s) const;
  void StatusLine(char *s);

  // The standout mode does not work the same on every terminal type.
  // In order to maintain porablity avoid using these functions in
  // code that needs to maintain a universal appearence when executed
  // across multiple platforms.
  void StandOut(const char *s, int x = -1, int y = -1) const;
  void StandOut(char *s, int x = -1, int y = -1);
  
public: // Input functions
  int KBWait() const;
  unsigned char GetChar();
  void GetString(char *string, int x = -1, int y = -1);
  void GetPassword(char *string, int x = -1, int y = -1);
  void PutBack(char c);
  int GetInt(int x = -1, int y = -1);
  long GetLong(int x = -1, int y = -1);
  double GetFloat(int x = -1, int y = -1);

private:
  char putback;
  int maxlines;
  int maxcols;
};

extern Terminal I_TERM;    // Independent Teminal type object
extern Terminal *terminal; // Global terminal pointer

#ifdef __DOS__
// ===============================================================
// Stand alone functions used to port this code from UNIX to DOS,
// Windows 3.11, and Windows 95. These functions are used to
// simulate the basic functionality of the vast CURSES library.
// All of these functions rely on the ANSI.SYS driver installed
// in the "config.sys" file: DEVICEHIGH=C:\WINDOWS\COMMAND\ANSI.SYS
// in Windows 95 or DEVICEHIGH=C:\DOS\ANSI.SYS in DOS/Windows 3.11.
// ===============================================================
// chtype is the type used to store a character together with attributes.
// It can be set to "char" to save space, or "long" to get more attributes.
#ifdef	CHTYPE
typedef	CHTYPE chtype;
#else
typedef unsigned long chtype;
#endif // CHTYPE 

extern int LINES, COLS;

// TRUE and FALSE get defined so many times, let's not get in the 
// way of other definitions.
#ifndef TRUE
#define	TRUE	1
#endif
#ifndef FALSE
#define	FALSE	0
#endif
#ifndef ERR
#define	ERR	-1
#endif
#ifndef OK 
#define	OK	0
#endif

int addch(const chtype c);
int addstr(const char *s);
int beep();
int clear();
int endwin();
int move(int y, int x);
int refresh();
int standend();
int standout();

// ===============================================================
// The folling code is used for PC enhancements, used to emulate
// the effect of the video attribute functions in the curses library.
// All of the escape codes are compatible with vt100 terminals.
void UnderlineText();
void BoldText();
void ReverseVideo();
void NormalText();
// ===============================================================
#endif // __DOS__

#endif  // __TERMINAL_HPP 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //



