// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: timer.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/11/1996 
// Date Last Modified: 09/11/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Sleep() function is used to pause the program for a given
number of seconds. The Start(), Stop(), and ElapsedSeconds()
functions are used to calculate elapsed CPU cycles in seconds.
*/
// ----------------------------------------------------------- // 
#ifndef __TIMER_HPP
#define __TIMER_HPP

#include <time.h>

// Sleep for specified number of seconds.
inline void Sleep(clock_t seconds)
{
  // Convert milliseconds to seconds
  clock_t wait = ( seconds * CLOCKS_PER_SEC );

  clock_t goal = wait + clock();
  while( goal > clock() )
    ;
}

// Sleep for specified number of seconds.
// Same as Sleep(), added to prevent name
// conflicts with other functions aready
// named Sleep().
inline void SleepFor(clock_t seconds)
{
  // Convert milliseconds to seconds
  clock_t wait = ( seconds * CLOCKS_PER_SEC );
  clock_t goal = wait + clock();
  while( goal > clock() )
    ;
}

// Pauses for a specified number of milliseconds. 
inline void PauseFor(clock_t wait)
{
  clock_t goal;
  goal = wait + clock();
  while( goal > clock() )
    ;
}

// Mark the starting time for the routine.
inline clock_t Start()
{
  return clock();
}

// Mark the stop time for the routine. 
inline clock_t Stop()
{
  return clock();
}

// Calculate the elapsed time in seconds.
inline clock_t ElapsedSeconds(clock_t begin, clock_t end)
{
  return (end - begin) / CLOCKS_PER_SEC;
}

// Calculate the elapsed time in milliseconds. 
inline double ElapsedTime(clock_t begin, clock_t end)
{
  return (double)(end - begin) / CLOCKS_PER_SEC;
}

#endif // __TIMER_HPP
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

