#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: GNU g++ 2.7.2.1
# Produced By: Doug Gaer
# File Creation Date: 03/31/1997 
# Date Last Modified: 10/23/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/

ADD_INC_PATHS = -I../base

# Setup define macros
DEFMACS = -D__UNIX__

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
TESTPROG_DEP = $(BASE_PATH)ustring.hpp

USTRING_DEP = $(BASE_PATH)ustring.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ustring.o:	$(BASE_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)ustring.cpp

# Make the executable
OBJS = testprog.o ustring.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
