// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: vbdref.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/03/1997  
// Date Last Modified: 07/23/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Reference counting is a technique used to ensure the safe
deletion or modification of an object when a copy of the
object exists. In order to create reference counted objects,
a class must inherit the CountedObject class to embed a
reference count into each object. The vbdRefCount class is
used to handle pointers to reference counted objects. It
works by storing pointers to objects in containers, rather
than the objects themselves. 
*/
// ----------------------------------------------------------- // 

#ifdef __NOT_USING_TEMPLATE_CLASS__
#include "vbdfile.hpp"

void vbdRefCount::Bind(const vbdRefCount &ptr)
// Binds object to the same object that ptr is bound to.
{
  ObjectPtr = ptr.ObjectPtr;
  if (ObjectPtr) ObjectPtr->IncRefCount();
}

void vbdRefCount::Unbind()
{
  // Ensure that ObjectPtr is pointing to an object
  if(ObjectPtr == 0) return; 

  ObjectPtr->DecRefCount();
  if (ObjectPtr->UnReferenced()) delete ObjectPtr;
}

void vbdRefCount::NewBinding(const vbdRefCount &ptr)
// Gives the reference counted pointer a new binding (the same as ptr)
{
  if (ObjectPtr != ptr.ObjectPtr) { // Prevents accidental deletion
    Unbind();
    Bind(ptr);
  }
}
#endif // __NOT_USING_TEMPLATE_CLASS__

// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
