#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 10/15/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
REFCOUNT_PATH = ../../refcount/base/
CRC32_PATH = ../../crc32/base/
TIMER_PATH = ../../timer/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../refcount/base \
-I../../dtypes/base -I../../crc32/base -I../../timer/base

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Setup define macros
DEFMACS = -D__X86__ -D__CONSOLE__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions -Wall $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm        
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

FLOAT64_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp 

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(CRC32_PATH)crc32.hpp \
	$(DTYPES_PATH)uint32.hpp

VBDSTATS_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(CRC32_PATH)crc32.hpp \
	$(DTYPES_PATH)uint32.hpp

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp $(DTYPES_PATH)int32.hpp \
        $(BASE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(DTYPES_PATH)uint32.hpp llist.hpp $(TIMER_PATH)timer.hpp \
	$(BASE_PATH)vbdstats.hpp

LLIST_DEP = llist.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

llist.o:	llist.cpp $(LLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) llist.cpp

float64.o:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(BASE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)vbdfile.cpp

vbdstats.o:    $(BASE_PATH)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

# Make the executable
OBJS = ehandler.o float64.o int32.o vbdfile.o \
	testprog.o crc32.o uint32.o llist.o \
	vbdstats.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe

	echo Removing any test files created during program execution
	rm -f *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
