#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 10/15/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
REFCOUNT_PATH = ../../refcount/base/
CRC32_PATH = ../../crc32/base/
TIMER_PATH = ../../timer/base/

ADD_INC_PATHS = /I../base /I../../ehandler/base /I../../refcount/base \
/I../../dtypes/base /I../../crc32/base /I../../timer/base

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

# Setup define macros
DEFMACS = /D__X86__ /D__CONSOLE__ /D__DOS_INCLUDES__ \
$(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /W3 /Zi /GX $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

FLOAT64_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp 

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(CRC32_PATH)crc32.hpp \
	$(DTYPES_PATH)uint32.hpp

VBDSTATS_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(CRC32_PATH)crc32.hpp \
	$(DTYPES_PATH)uint32.hpp

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp $(DTYPES_PATH)int32.hpp \
        $(BASE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(DTYPES_PATH)uint32.hpp llist.hpp $(TIMER_PATH)timer.hpp \
	$(BASE_PATH)vbdstats.hpp

LLIST_DEP = llist.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

llist.obj:	llist.cpp $(LLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) llist.cpp

float64.obj:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)float64.cpp

int32.obj:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.obj:    $(BASE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)vbdfile.cpp

vbdstats.obj:    $(BASE_PATH)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)vbdstats.cpp

uint32.obj:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.obj:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

# Make the executable
OBJS = ehandler.obj float64.obj int32.obj vbdfile.obj \
	testprog.obj crc32.obj uint32.obj llist.obj \
	vbdstats.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 

	@echo Removing any test files created during program execution
	if exist *.vbd del *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


