#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: HP C++ A.10.24 compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 10/15/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
#
# To get the current compiler version number enter the 
# following command:
# 
# 	% what /opt/CC/bin/CC
#
# NOTE: Edit the unix.env path to change the path setting
# for the wxWindows GUI library installation path
# ---------------------------------------------------------------

# Set the wxWindows GUI library installation path marco
include ../../../env/wx_unix.env

# All common UNIX compiler flags and options are now in
# this central makefile.
include $(WXDIR)/src/make.env

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
REFCOUNT_PATH = ../../refcount/base/
CRC32_PATH = ../../crc32/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../refcount/base \
-I../../dtypes/base -I../../crc32/base

# Setup define macros
DEFMACS = -D__wxWINDOWS__ -DCPP_EXCEPTIONS 

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld   # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= $(CPPFLAGS) $(DEFMACS) $(ADD_INC_PATHS) 
COMPILE_ONLY = -c
OUTPUT = -o
LINK_FLAGS = $(LDFLAGS) 
LINK_LIBS = $(MOTIFLDLIBS)

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

FLOAT64_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp 

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp 

VBDSTATS_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp 

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp $(DTYPES_PATH)int32.hpp \
        $(BASE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(DTYPES_PATH)uint32.hpp $(BASE_PATH)vbdstats.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

float64.o:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)float64.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(BASE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)vbdfile.cpp

vbdstats.o:    $(BASE_PATH)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(CRC32_PATH)crc32.cpp

# Make the executable
OBJECTS = ehandler.o float64.o int32.o vbdfile.o testprog.o \
	crc32.o uint32.o vbdstats.o

$(PROJECT):	$(OBJECTS) $(WXLIB)
	$(CPP) $(COMPILE_FLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) \
	$(LINK_FLAGS) $(LINK_LIBS) 

# ===============================================================
# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing any test files created during program execution
	rm -f testfile.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
