#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 10/15/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup wxWindows for MSVC 4.0
!include ..\..\..\env\wx_msvc.env
!include $(WXDIR)\src\ntwxwin.mak

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
REFCOUNT_PATH = ../../refcount/base/
CRC32_PATH = ../../crc32/base/

ADD_INC_PATHS = /I../base /I../../ehandler/base /I../../refcount/base \
/I../../dtypes/base /I../../crc32/base

# Setup define macros
DEFMACS = /D__wxWINDOWS__ /D__X86__ /DCPP_EXCEPTIONS 

# Define macros for compiler and linker
AC     = cl   # ANSI c compiler
CPP    = cl   # C++ compiler
LINKER = link # Linker

# Resource compiler for MSVC
RC = rc

# Compiler and linker flags 
COMPILE_FLAGS= $(CPPFLAGS2) $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LINK_FLAGS = $(LINKFLAGS)
LINK_LIBS = $(LIBS)

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

FLOAT64_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp 

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp 

VBDSTATS_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(BASE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp 

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)float64.hpp $(DTYPES_PATH)int32.hpp \
        $(BASE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(DTYPES_PATH)uint32.hpp $(BASE_PATH)vbdstats.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

float64.obj:	$(DTYPES_PATH)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)float64.cpp

int32.obj:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.obj:    $(BASE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)vbdfile.cpp

vbdstats.obj:    $(BASE_PATH)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(BASE_PATH)vbdstats.cpp

uint32.obj:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(DTYPES_PATH)uint32.cpp

crc32.obj:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(CRC32_PATH)crc32.cpp

testprog.res:	testprog.rc $(WXDIR)\include\msw\wx.rc
	$(RC) -r /i$(WXDIR)\include\msw /i$(WXDIR)\contrib\fafa -fo$@ \
	testprog.rc

# Make the executable
OBJECTS = ehandler.obj float64.obj int32.obj vbdfile.obj testprog.obj \
	crc32.obj uint32.obj vbdstats.obj

RCS = testprog.res

$(PROJECT).exe:	$(DUMMYOBJ) $(OBJECTS) $(RCS) $(WXLIB)
	$(LINKER) $(LINK_FLAGS) $(DUMMYOBJ) $(OBJECTS) $(RCS) \
	$(LINK_LIBS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .RES files from working directory...
	if exist *.res del *.res 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 

	@echo Removing any test files created during program execution
	if exist *.vbd del *.vbd
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


