#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 04/14/1997 
# Date Last Modified: 10/07/1998 
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh -- Enable C++ exception handling
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup path for VBD Base installation directory
# The $(VBDDIR) is defined in the include file.
include ../../../env/vbd_unix.env

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
BTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)btree$(PATHSEP)base
CACHE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)cache$(PATHSEP)base
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)placenew$(PATHSEP)base
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base
TIMER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)timer$(PATHSEP)base
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)strutil$(PATHSEP)base

ADD_INC_PATHS = -I$(EHANDLER_PATH) -I$(DTYPES_PATH) -I$(VBDFILE_PATH) \
-I$(REFCOUNT_PATH) -I$(BTREE_PATH) -I$(CACHE_PATH) -I$(PLACENEW_PATH) \
-I$(CRC32_PATH) -I$(TIMER_PATH) -I$(STRUTIL_PATH)

# Use this DEFMACS macro to compile without using template classes
#DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
#-D__USE_VBDREFCOUNT__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Enable to use the template classes
DEFMACS = -D__CONSOLE__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g +a1 -pta +eh $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

TIMER_DEP = $(TIMER_PATH)$(PATHSEP)timer.hpp 

STRUTIL_DEP = $(STRUTIL_PATH)$(PATHSEP)strutil.hpp 

BUCKET_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp 

CACHE_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp 

CACHEB_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp

CACSTATS_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp

CHPTRB_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp

MNODE_DEP = $(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

ENTRYKEY_DEP = $(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp 

BTREE_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

BTREEPRT_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp

INT32_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

VBDREF_DEP = $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp

TESTPROG_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
        $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp \
	$(TIMER_PATH)$(PATHSEP)timer.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

cacstats.o:	$(CACHE_PATH)$(PATHSEP)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacstats.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btreeprt.o:	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.o chptrb.o btree.o ehandler.o vbdfile.o \
	testprog.o mnode.o int32.o bucket.o cache.o \
	vbdref.o entrykey.o btreeprt.o cacstats.o \
	uint32.o crc32.o strutil.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing any test files created during program execution
	rm -f *.btx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
