#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 10/07/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup path for VBD Base installation directory
# The $(VBDDIR) is defined in the include file.
!include ..\..\..\env\vbd_msvc.env

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
BTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)btree$(PATHSEP)base
CACHE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)cache$(PATHSEP)base
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)placenew$(PATHSEP)base
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base
TIMER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)timer$(PATHSEP)base
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)strutil$(PATHSEP)base

ADD_INC_PATHS = /I$(EHANDLER_PATH) /I$(DTYPES_PATH) /I$(VBDFILE_PATH) \
/I$(REFCOUNT_PATH) /I$(BTREE_PATH) /I$(CACHE_PATH) /I$(PLACENEW_PATH) \
/I$(CRC32_PATH) /I$(TIMER_PATH) /I$(STRUTIL_PATH)

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = /D__NOT_USING_TEMPLATE_CLASS__ /D__BTREE_MNODE__ /D__CONSOLE__ \
/D__USE_VBDREFCOUNT__ /D__DOS__ $(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Enable to use the template classes
# DEFMACS = /D__CONSOLE__ /D__DOS__ $(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /GX $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

TIMER_DEP = $(TIMER_PATH)$(PATHSEP)timer.hpp 

STRUTIL_DEP = $(STRUTIL_PATH)$(PATHSEP)strutil.hpp 

BUCKET_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp 

CACHE_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp 

CACHEB_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp

CACSTATS_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp

CHPTRB_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp

MNODE_DEP = $(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

ENTRYKEY_DEP = $(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp 

BTREE_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

BTREEPRT_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp

INT32_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

VBDREF_DEP = $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp

TESTPROG_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
        $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp \
	$(TIMER_PATH)$(PATHSEP)timer.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

uint32.obj:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.obj:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

strutil.obj:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

bucket.obj:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.obj:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.obj:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.obj:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

cacstats.obj:	$(CACHE_PATH)$(PATHSEP)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacstats.cpp

mnode.obj:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.obj:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btreeprt.obj:	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp

btree.obj:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.obj:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

int32.obj:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

vbdfile.obj:    $(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vbdref.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.obj chptrb.obj btree.obj ehandler.obj vbdfile.obj \
	testprog.obj mnode.obj int32.obj bucket.obj cache.obj \
	vbdref.obj entrykey.obj btreeprt.obj cacstats.obj \
	uint32.obj crc32.obj strutil.obj
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 

	@echo Removing any test files created during program execution
	if exist *.btx del *.btx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


