// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: ccindex.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 10/29/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The CCIndex class is a persistent string VBD database used
to store various name and address information in a 3" X 5"
index card file format. All the string members can grow and
shrink as needed.
*/
// ----------------------------------------------------------- //   
#ifndef __CCINDEX_HPP__
#define __CCINDEX_HPP__

#include "persist.hpp"

const INT32 CCIndexVersion = 1998; // CCIndex class version number
const INT32 SClassID = 53198;      // Unique class ID for this database

// String Database class
class CCIndex : public Persistent
{
public:
  CCIndex() {
    card_name = company_name = department_name = phone_number = fax_number =
      cell_number = beeper_number =  email_address = street_address =
      internet_urls = comments_block = "\0";
  }

  CCIndex(const POD *pod) : Persistent(pod) {
    card_name = company_name = department_name = phone_number = fax_number =
      cell_number = beeper_number =  email_address = street_address =
      internet_urls = comments_block = "\0";
  }

  CCIndex(POD *pod) : Persistent(pod) {
    card_name = company_name = department_name = phone_number = fax_number =
      cell_number = beeper_number =  email_address = street_address =
      internet_urls = comments_block = "\0";
  }

  CCIndex(const CCIndex &ob) { Copy(ob); }
  void operator=(const CCIndex &ob) { Copy(ob); }
  
public: 
  void SetCardName(const char *s) { card_name = s; }
  void SetCardName(const UString &s) { card_name = s; }
  void SetCompanyName(const char *s) { company_name = s; }
  void SetCompanyName(const UString &s) { company_name = s; }
  void SetDepartmentName(const char *s) { department_name = s; }
  void SetDepartmentName(const UString &s) { department_name = s; }
  void SetPhoneNumber(const char *s) { phone_number = s; }
  void SetPhoneNumber(const UString &s) { phone_number = s; }
  void SetFaxNumber(const char *s) { fax_number = s; }
  void SetFaxNumber(const UString &s) { fax_number = s; }
  void SetCellNumber(const char *s) { cell_number = s; }
  void SetCellNumber(const UString &s) { cell_number = s; }
  void SetBeeperNumber(const char *s) { beeper_number = s; }
  void SetBeeperNumber(const UString &s) { beeper_number = s; }
  void SetEmailAddress(const char *s) { email_address = s; }
  void SetEmailAddress(const UString &s) { email_address = s; }
  void SetStreetAddress(const char *s) { street_address = s; }
  void SetStreetAddress(const UString &s) { street_address = s; }
  void SetInternetURLS(const char *s) { internet_urls = s; }
  void SetInternetURLS(const UString &s) { internet_urls = s; }
  void SetCommentsBlock(const char *s) { comments_block = s; }
  void SetCommentsBlock(const UString &s) { comments_block = s; }
  const char *GetCardName() const { return card_name.c_str(); }
  char *GetCardName() { return card_name.c_str(); }
  const char *GetDepartmentName() const { return department_name.c_str(); }
  char *GetDepartmentName() { return department_name.c_str(); }
  const char *GetCompanyName() const { return company_name.c_str(); }
  char *GetCompanyName() { return company_name.c_str(); }
  const char *GetPhoneNumber() const { return phone_number.c_str(); }
  char *GetPhoneNumber() { return phone_number.c_str(); }
  const char *GetFaxNumber() const { return fax_number.c_str(); }
  char *GetFaxNumber() { return fax_number.c_str(); }
  const char *GetCellNumber() const { return cell_number.c_str(); }
  char *GetCellNumber() { return cell_number.c_str(); }
  const char *GetBeeperNumber() const { return beeper_number.c_str(); }
  char *GetBeeperNumber() { return beeper_number.c_str(); }
  const char *GetEmailAddress() const { return email_address.c_str(); }
  char *GetEmailAddress() { return email_address.c_str(); }
  const char *GetStreetAddress() const { return street_address.c_str(); }
  char *GetStreetAddress() { return street_address.c_str(); }
  const char *GetInternetURLS() const { return internet_urls.c_str(); }
  char *GetInternetURLS() { return internet_urls.c_str(); }
  const char *GetCommentBlock() const { return comments_block.c_str(); }
  char *GetCommentsBlock() { return comments_block.c_str(); }
  INT32 Version() { return CCIndexVersion; }

public:
  void Copy(const CCIndex &ob);
  int FullCompare(const CCIndex &ob);

private: // Base class interface
  virtual FAU Write();
  virtual void Read(FAU Address);
  virtual FAU Find();
  virtual FAU Delete();
  virtual FAU Remove();

public: // Base class interface
  virtual INT32 GetClassID() const { return SClassID; }
  virtual const char *GetClassName() { return "Class CCIndex"; }
  virtual unsigned ObjectLength();
  virtual void SetObjectAddress(FAU addr) { objectaddress = addr; }
  virtual FAU GetObjectAddress() { return objectaddress; }
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);

public: // Overloaded operators
  friend int operator==(const CCIndex &a, const CCIndex &b);
  friend int operator!=(const CCIndex &a, const CCIndex &b);
  friend int operator>(const CCIndex &a, const CCIndex &b);
  friend int operator>=(const CCIndex &a, const CCIndex &b);
  friend int operator<(const CCIndex &a, const CCIndex &b);
  friend int operator<=(const CCIndex &a, const CCIndex &b);
  
private:
  UString card_name;
  UString company_name;
  UString department_name;
  UString phone_number;
  UString fax_number;
  UString cell_number;
  UString beeper_number;
  UString email_address;
  UString street_address;
  UString internet_urls;
  UString comments_block;
};

#endif  // __CCINDEX_HPP__ 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
