// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: winmain.hpp
// C++ Compiler Used: MSVC40, HPUX CPP 10.24 
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 11/04/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a index card file program designed to work with the
wxWindow GUI library version 1.68

- Modify "dbconfig.hpp" file to customize the database
- Modify "version.hpp" file to report changes and fixes
*/
// ----------------------------------------------------------- //
#ifndef __WINMAIN_HPP__
#define __WINMAIN_HPP__

#include "ccindex.hpp"
#include "config.hpp"
#include "dbconfig.hpp"
#include "version.hpp"
#include "ccidx_sh.hpp"
#include "pscript.hpp"

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx_prec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx.h"
#endif

// Define this macro to use the wxWindows printing features under
// Microsoft Windows. A separate PostScript driver is provided for
// UNIX system. Define this macro for UNIX compiles to enable MSW
// style printing in motif using wxWindow 1.68B.
// #ifndef __USE_MSW_PRINTING__
// #define __USE_MSW_PRINTING__
// #endif

#ifdef __USE_MSW_PRINTING__
// Setup wxWindows printing for MSW
#if !USE_PRINTING_ARCHITECTURE
#error You must set USE_PRINTING_ARCHITECTURE to 1 in wx_setup.h to compile 
#endif

#include "wx_mf.h"
#include "wx_print.h"
#endif // __USE_MSW_PRINTING__

// Define new frame types for wxWindow frames and sub-frames
class MyFrame;       // Main window frame
class MyTextWindow;  // Text windos frames
class MyText;        // Class used to encapsulate wxText objects

// Define configurable parameters
int CacheSize = 15;  // Memory cache size for the index file
int AdminRights = 0; // Define user privileges 

// Define file access modes used in the application
VBDFile::AccessMode RWMode = VBDFile::READWRITE;
VBDFile::AccessMode ROMode = VBDFile::READONLY;

// Function prototypes for wxWindows controls
void AddBtnProc(wxButton& but, wxCommandEvent& event);
void ClearAddPanel();
void ChBtnProc(wxButton& but, wxCommandEvent& event);
void ClearChangePanel();
void DsBtnProc(wxButton& but, wxCommandEvent& event);
void ClearDisplayPanel();
void text_proc(wxText &but, wxCommandEvent &event);

#ifdef __USE_MSW_PRINTING__
void  page_btn_proc(wxButton& but, wxCommandEvent& event);
#endif // __USE_MSW_PRINTING__

// File menu functions
void ExportToASCII(MyTextWindow &textWin);
void ImportFromASCII(MyTextWindow &textWin);
void BackUp(MyTextWindow &textWin);
void Merge(MyTextWindow &textWin);
void CreateTemplate(MyTextWindow &textWin);
void CompareIndexFile(MyTextWindow &textWin);
void RebuildIndexFile(MyTextWindow &textWin);

// Database menu functions
void Add(MyTextWindow &textWin);
void Change(MyTextWindow &textWin);
void Remove(MyTextWindow &textWin, char *keyNM = 0);
void DisplayDB(MyTextWindow &textWin); 

// Find menu functions
void FindBy(MyTextWindow &textWin, const char *MemberName, CCIndexItem item);

// Print menu functions
void ASCIIPrint(MyTextWindow &textWin); // Print abbreviated listing
void ASCIIPrintObject(MyTextWindow &textWin, char *keyNM = 0);
void PostScriptPrint(MyTextWindow & textWin);

// View menu functions
void Clear(MyTextWindow &textWin);

// Function prototypes for non-menu functions
void DisplayObject(CCIndex &ccindex);
int LoadIndexKeys(int build_new_tree = 1, int clear_tree = 1);

// ASCII printing, export, import constants and functions
const int StringOffset = 25;  // Output limit per string for ASCII printing
void asPrintwxText(char *title, char *str, ofstream &stream);
void asPrintwxMultiText(char *title, char *str, ofstream &stream);
void ExportPrintwxMultiText(char *str, ofstream &stream);
char *ImportFormatwxMultiText(char *str);

// PostScript printing constants and functions
const double psSEPARATOR = 2.0; // Spacing between data members

void PSPrintwxText(PostScriptDrv &psdrv, ofstream &stream, char *title,
		   char *str, int char_offset, int cell_len, double font_size,
		   PostScriptDrv::PSFonts item_font,
		   PostScriptDrv::PSFonts cell_font);

void PSPrintwxMultiText(PostScriptDrv &psdrv, ofstream &stream, char *title,
			char *str, int char_offset, int cell_len,
			double font_size, PostScriptDrv::PSFonts item_font,
			PostScriptDrv::PSFonts cell_font);

// Search functions
void CCIndexSearch(CCIndex &ccindex, CCIndexItem item, UString &str,
		   MyTextWindow &textWin, const char *wildcard = 0);

// Version number for this windows program 
char *VerNumber();

// Control key macro used for wxWindows key events
#define CONTROL(c) ((c) & 037)

// Identification for the all wxWindows main menu functions
enum MainMenu {
  // File menu constants
  FILE_QUIT = 1,
  FILE_VBDSTATS,
  FILE_EXPORT,
  FILE_IMPORT,
  FILE_BACKUP,
  FILE_MERGE,
  FILE_TEMPLATE,
  FILE_COMPARE_INDEX,
  FILE_REBUILD_INDEX,
  
  // Edit menu constants
  EDIT_CUT,   
  EDIT_COPY,  
  EDIT_PASTE, 

  // Database menu constants
  DB_DISPLAY,
  DB_ADD,
  DB_CHANGE,
  DB_REMOVE,
  
  // Find menu constants
  FIND_BYKEYNAME,
  FIND_BYM1NAME,
  FIND_BYM2NAME,
  FIND_BYM3NAME,
  FIND_BYM4NAME,
  FIND_BYM5NAME,
  FIND_BYM6NAME,
  FIND_BYM7NAME,
  FIND_BYM8NAME,
  FIND_BYM9NAME,
  FIND_BYCOMMENTS,
  
  // Print menu constants
  WXPRINT_PRINT,
  WXPRINT_PRINTER_SETUP,
  WXPRINT_PREVIEW,
  WXPRINT_PAGE_SETUP,
  PRINT_POSTSCRIPT,
  PRINT_ASCII,
  PRINT_ASCIIOBJECT,
  
  // View menu constants
  VIEW_CLEAR,
  
  // Help menu constants
  HELP_ABOUT,
  HELP_USERLEVEL
};

// Define control button tags for wxWindow panel buttons
#define ADD_BUTTON_ADD     1
#define ADD_BUTTON_CANCEL  2
#define ADD_BUTTON_CLOSE   3
#define ADD_BUTTON_REVERT  4

#define CHANGE_BUTTON_CM     11
#define CHANGE_BUTTON_CANCEL 12
#define CHANGE_BUTTON_CLOSE  13
#define CHANGE_BUTTON_REVERT 14
#define CHANGE_BUTTON_SH     15

#define DISPLAY_BUTTON_NX     21
#define DISPLAY_BUTTON_PREV   22
#define DISPLAY_BUTTON_CHANGE 23
#define DISPLAY_BUTTON_CLOSE  24
#define DISPLAY_BUTTON_REMOVE 25

#ifdef __USE_MSW_PRINTING__
#define PAGE_DIALOG_BUTTON_CLOSE   400
#define PAGE_DIALOG_BUTTON_ACCEPT  401
#define PAGE_DIALOG_BUTTON_CANCEL  402
#define PAGE_DIALOG_BUTTON_DEFAULT 403
#endif // __USE_MSW_PRINTING__

// Define a new text subwindow that can respond to drag-and-drop
class MyTextWindow: public wxTextWindow
{
public:
  MyTextWindow(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
               long style=0):
    wxTextWindow(frame, x, y, width, height, style) { DragAcceptFiles(TRUE); }

public:
  void OnDropFiles(int n, char *files[], int x, int y) { LoadFile(files[0]); }
  void OnChar(wxKeyEvent& event);
};

// Define a new application type
class MyApp: public wxApp
{
public:
  wxFrame *OnInit();
};

// Define a new frame type
class MyFrame: public wxFrame
{
public:
  MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);

public:
  void OnMenuCommand(int id);
  void OnSize(int w, int h);
  Bool OnClose();
  void OnActivate(Bool active) { }
  
public:
  MyTextWindow *textWin;  // Text window for main frame
  wxPanel *apanel;        // Panel for adding objects
  wxPanel *cpanel;        // Panel for changing object
  wxPanel *dpanel;        // Panel for display objects
  MyText *addText;        // wxText object used for the apanel
  MyText *changeText;     // wxText object used for the cpanel
  MyText *displayText;    // wxText object used for the dpanel
};

class MyText: public wxText
{
public:
  MyText(wxPanel *parent, wxFunction func, char *label, char *value = "",
	    int x = -1, int y = -1, int width = -1, int height = -1,
	    long style = 0, char *name = "text");

  MyText() { key = m1 = m2 = m3 = m4 = m5 = m6 = m7 = 0; m8 = m9 = cmt = 0; }
  ~MyText();
  
public:
  wxText *key;      // Program identifier for the key data member
  wxText *m1;       // Program identifier for data member number 1
  wxText *m2;       // Program identifier for data member number 2
  wxText *m3;       // Program identifier for data member number 3
  wxText *m4;       // Program identifier for data member number 4
  wxText *m5;       // Program identifier for data member number 5
  wxText *m6;       // Program identifier for data member number 6
  wxText *m7;       // Program identifier for data member number 7
  wxMultiText *m8;  // Program identifier for data member number 8
  wxMultiText *m9;  // Program identifier for data member number 9
  wxMultiText *cmt; // Program identifier for the comments member
};

// Setup wxWindows printing for MSW
#ifdef __USE_MSW_PRINTING__

// wxWindows MSW Printer defaults
// NOTE: Left/Right and Top/Bottom magrins are in logical units (20 per inch). 
const int mswpCARDS_PER_PAGE = 2;     // Default cards per page
const int mswpCELL_LENGTH = 25;       // Default cell length for spacing
const int mswpFONT_SIZE = 10;         // Default font size
const int mswpLR_MARGINS = 20;        // Default for left/right margins
const int mswpCARD_SPACING = 20;      // Default spacing between cards
const int mswpORIENTATION = 0;        // Default to landsacpe
const int mswpFONT = 0;               // Default font code: 0 = wxSWISS
const int mswpTB_MARGINS = 20;        // Default for 1" top/bottom margins
const int mswpLINE_WIDTH = 2;         // Line width for separator lines
const int mswpSEPARATOR = 5;          // Space between data members 
const int mswpPRINTABLE_OFFSET_X = 5; // Printable page area x offset
const int mswpPRINTABLE_OFFSET_Y = 5; // Printable page area y offset

// Data structure use to hold various parameters for MSW printing
struct MSWPrintingParameters
{
  MSWPrintingParameters() {
    // Set current print settings using the mswp defaults
    cards_per_page = mswpCARDS_PER_PAGE; 
    cell_length = mswpCELL_LENGTH;    
    font_size = mswpFONT_SIZE;   
    orientation = mswpORIENTATION;
    font = mswpFONT;        
    lr_margin = mswpLR_MARGINS;  
    card_spacing = mswpCARD_SPACING;
    tb_margin = mswpTB_MARGINS; 
    
    // Set previous print setting
    prev_cards_per_page = cards_per_page;
    prev_cell_length = cell_length;
    prev_font_size = font_size;
    prev_orientation = orientation;
    prev_font = font;
    prev_lr_margin = lr_margin;
    prev_card_spacing = card_spacing;
    prev_tb_margin = tb_margin;
    
    // Set default print setting
    default_cards_per_page = cards_per_page;
    default_cell_length = cell_length;
    default_font_size = font_size;
    default_orientation = orientation;
    default_font = font;
    default_lr_margin = lr_margin;
    default_card_spacing = card_spacing;
    default_tb_margin = tb_margin;
  }    

  // Current print settings
  int cards_per_page; // Number of line per page
  int cell_length;    // Spacing between the entry fields
  int font_size;      // Font or point size fot the object's data
  int orientation;    // 0 == Landscape, 1 == Portrait
  float lr_margin;    // Left and right magrin in logical units (20 per inch) 
  int card_spacing;   // Spacing between cards
  float tb_margin;    // Top and bottom magrin in logical units (20 per inch)
  int font;           // Font codes must match FontChoiceStrings array:
                      // 0 = wxSWISS
                      // 1 = wxROMAN
                      // 2 = wxDECORATIVE
                      // 3 = wxMODERN 
                      // 4 = wxSCRIPT
                      // 5 = wxDEFAULT
  
  // Previous print setting
  int prev_cards_per_page;
  int prev_cell_length;
  int prev_font_size;
  int prev_orientation;
  float prev_lr_margin;
  int prev_card_spacing;   
  float prev_tb_margin;
  int prev_font;
  
  int default_cards_per_page;
  int default_cell_length;
  int default_font_size;
  int default_orientation;
  float default_lr_margin;
  int default_card_spacing;   
  float default_tb_margin;
  int default_font;
};

// Declare a global printer page setup for MSW printing
extern MSWPrintingParameters MSWPrnPars;
extern MSWPrintingParameters *MSWPrintSetup;

// (w)xWindows (S)tring (D)atabase (P)rinting class
class wCCIndexPrint: public wxPrintout
{
public:
  wCCIndexPrint(char *title):wxPrintout(title) { }

public: // Override virtual functions in base class 
  Bool OnPrintPage(int page);
  Bool HasPage(int page);
  Bool OnBeginDocument(int startPage, int endPage);
  void OnPreparePrinting();
  void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom,
		   int *selPageTo);

public: 
  void SetPrinterFont(int style = wxNORMAL, int weight = wxNORMAL);
  void SetHeaderFont(int size, int font, int style, int weight);
  void SetItemBarFont(int style = wxITALIC, int weight = wxBOLD);
  void ScaleDC(wxDC *dc);
  void PrintText(wxDC *dc, char *s, int max_len, float xpos, float ypos);
  void PrintText(wxDC *dc, char *s, float xpos, float ypos);
  void PrintText(wxDC *dc, char c, float xpos, float ypos);  
  void PrintText(wxDC *dc, int i, float xpos, float ypos);
  void PrintText(wxDC *dc, long i, float xpos, float ypos);
  void PrintText(wxDC *dc, double i, float xpos, float ypos);
  void PrintText(wxDC *dc, float i, float xpos, float ypos);
  void DrawTextPage(wxDC *dc, int page);
  void WritePageHeader(wxDC *dc, char *doc_name, char *doc_date = 0);
  void WritePageNumber(wxDC *dc, int pagenum);

  void PrintMultiText(wxDC *dc, char *title, char *str, int char_offset,
		      float *xpos, float *ypos);
  void PrintwxText(wxDC *dc, char *title, char *str,
		   int char_offset, float *xpos, float *ypos);

private: // Font dependent members
  wxFont *printerFont; // Text font for object's data
  wxFont *itemFont;    // Text font for the item bar
  wxFont *headerFont;  // Text font for page header and page numbers
  float char_width;    // Width of each character based on the font type

private: // Page dependent members
  int page_width;  // Page width in millimetres
  int page_height; // Page height in millimetres
  float start_x;   // Starting x position 
  float start_y;   // Starting y position 

private: // Device Context/Page scaling members
  float logUnitsFactor; // Factor for converting millimetres to logical units
  float scale;          // Factor for printout/screen scaling.
  int ppiScreenX;       // Logical pixels per inch of screen
  int ppiScreenY;       // Logical pixels per inch of screen
  int ppiPrinterX;      // Logical pixels per inch of screen
  int ppiPrinterY;      // Logical pixels per inch of screen
};

#endif // __USE_MSW_PRINTING__

#endif // __WINMAIN_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

