#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 10/06/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# 	Zp -- Byte align structures (leave no gaps between members)
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup wxWindows for MSVC 4.0
!include ..\..\..\env\wx_msvc.env
!include $(WXDIR)\src\ntwxwin.mak

# Setup path for VBD Base installation directory
# The $(VBDDIR) is defined in the include file.
!include ..\..\..\env\vbd_msvc.env

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base

ADD_INC_PATHS = /I$(EHANDLER_PATH) /I$(DTYPES_PATH) \
/I$(VBDFILE_PATH) /I$(REFCOUNT_PATH) /I$(CRC32_PATH)

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = /D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = /D__RECLAIM_FIRST_FIT__ 

# Setup define macros
DEFMACS = /D__wxWINDOWS__ $(DEF_VB_ALLOC) # /DCPP_EXCEPTIONS

# Define macros for compiler and linker
AC     = cl   # ANSI c compiler
CPP    = cl   # C++ compiler
LINKER = link # Linker

# Resource compiler for MSVC
RC = rc

# Compiler and linker flags 
COMPILE_FLAGS= $(CPPFLAGS2) $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = /c
LINK_FLAGS = $(LINKFLAGS)
LINK_LIBS = $(LIBS)

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp 

VBDFILE_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

INT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

TESTPROG_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

uint32.obj:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.obj:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

ehandler.obj:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.obj:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

int32.obj:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

testprog.res:	testprog.rc $(WXDIR)\include\msw\wx.rc
	$(RC) -r /i$(WXDIR)\include\msw /i$(WXDIR)\contrib\fafa -fo$@ \
	testprog.rc

# Make the executable
OBJECTS = ehandler.obj vbdfile.obj testprog.obj \
	int32.obj crc32.obj uint32.obj

RCS = testprog.res

$(PROJECT).exe:	$(DUMMYOBJ) $(OBJECTS) $(RCS) $(WXLIB)
	$(LINKER) $(LINK_FLAGS) $(DUMMYOBJ) $(OBJECTS) $(RCS) \
	$(LINK_LIBS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .RES files from working directory...
	if exist *.res del *.res 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


